/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.ui.editor.partitioning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditorInput;
import org.eclipse.gmf.runtime.diagram.ui.providers.DiagramContextMenuProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.util.Arrays;
import org.yakindu.base.base.NamedElement;
import org.yakindu.sct.model.sgraph.Statechart;
import org.yakindu.sct.model.sgraph.provider.SGraphItemProviderAdapterFactory;
import org.yakindu.sct.ui.editor.StatechartImages;
import org.yakindu.sct.ui.editor.partitioning.DiagramPartitioningBreadcrumbViewer;
import org.yakindu.sct.ui.editor.partitioning.DiagramPartitioningDocumentProvider;
import org.yakindu.sct.ui.editor.partitioning.DiagramPartitioningUtil;

public abstract class DiagramPartitioningEditor
extends DiagramDocumentEditor
implements ISelectionChangedListener,
IEditingDomainProvider {
    private DiagramPartitioningBreadcrumbViewer viewer;
    private DiagramPartitioningDocumentProvider documentProvider = new DiagramPartitioningDocumentProvider();

    public DiagramPartitioningEditor(boolean hasFlyoutPalette) {
        super(hasFlyoutPalette);
    }

    public TransactionalEditingDomain getEditingDomain() {
        return DiagramPartitioningUtil.getSharedDomain();
    }

    public IDocumentProvider getDocumentProvider() {
        return this.documentProvider;
    }

    public void createPartControl(Composite parent) {
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(parent);
        this.createBreadcrumbViewer(parent);
        super.createPartControl(parent);
    }

    protected void sanityCheckState(IEditorInput input) {
        super.sanityCheckState(input);
        if (this.getDiagram() != null && this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.setInput(DiagramPartitioningUtil.getDiagramContainerHierachy(this.getDiagram()));
        }
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        if (input instanceof IDiagramEditorInput) {
            this.initializeTitle((IDiagramEditorInput)input);
        }
    }

    protected void initializeTitle(IDiagramEditorInput input) {
        Diagram diagram = input.getDiagram();
        EObject element = diagram.getElement();
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)new SGraphItemProviderAdapterFactory());
        this.setTitleImage(labelProvider.getImage((Object)element));
        this.setPartName(labelProvider.getText((Object)element));
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.configureContextMenu();
    }

    protected void configureContextMenu() {
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        FilteringDiagramContextMenuProvider provider = new FilteringDiagramContextMenuProvider((IWorkbenchPart)this, (EditPartViewer)graphicalViewer);
        graphicalViewer.setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu("org.eclipse.gmf.runtime.diagram.ui.DiagramEditorContextMenu", (MenuManager)provider, (ISelectionProvider)this.viewer);
    }

    private void createBreadcrumbViewer(Composite parent) {
        this.viewer = new DiagramPartitioningBreadcrumbViewer(parent, 8);
        this.viewer.addSelectionChangedListener(this);
        this.viewer.setContentProvider((IContentProvider)new BreadcrumbViewerContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new BreadcrumbViewerLabelProvider());
        this.viewer.setInput(DiagramPartitioningUtil.getDiagramContainerHierachy(this.getDiagram()));
        parent.pack(true);
    }

    protected void createGraphicalViewer(Composite parent) {
        super.createGraphicalViewer(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Diagram diagramToOpen = (Diagram)((IStructuredSelection)event.getSelection()).getFirstElement();
        DiagramPartitioningUtil.openEditor(diagramToOpen);
    }

    public void dispose() {
        this.closeSubdiagramEditors();
        super.dispose();
    }

    protected void closeSubdiagramEditors() {
        if (this.getDiagram().getElement() instanceof Statechart) {
            boolean close;
            IEditorReference[] refs;
            ArrayList<IEditorReference> references = new ArrayList<IEditorReference>();
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (workbenchWindow == null) {
                return;
            }
            IWorkbenchPage activePage = workbenchWindow.getActivePage();
            if (activePage == null) {
                return;
            }
            IEditorReference[] iEditorReferenceArray = refs = activePage.getEditorReferences();
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference ref = iEditorReferenceArray[n2];
                try {
                    IDiagramEditorInput diagramInput;
                    if (ref.getEditorInput() instanceof IDiagramEditorInput && (diagramInput = (IDiagramEditorInput)ref.getEditorInput()).getDiagram().eResource() == this.getDiagram().eResource()) {
                        references.add(ref);
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            if (references.size() > 0 && (close = MessageDialog.openQuestion((Shell)activePage.getActivePart().getSite().getShell(), (String)"Close subdiagram editors?", (String)"There are still subdiagram editors open. Do you want to close them?"))) {
                IEditorReference[] iEditorReferenceArray2 = refs;
                int n3 = refs.length;
                n = 0;
                while (n < n3) {
                    IEditorReference ref = iEditorReferenceArray2[n];
                    activePage.closeEditor(ref.getEditor(false), false);
                    ++n;
                }
            }
        }
    }

    public static final class BreadcrumbViewerContentProvider
    implements ITreePathContentProvider {
        private List<IFile> input;

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null && newInput instanceof List) {
                this.input = (List)newInput;
            }
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return null;
        }

        public Object[] getChildren(TreePath parentPath) {
            return this.input.subList(parentPath.getSegmentCount(), this.input.size()).toArray();
        }

        public void dispose() {
            this.input = null;
        }

        public boolean hasChildren(TreePath path) {
            return false;
        }

        public TreePath[] getParents(Object element) {
            return null;
        }
    }

    public static final class BreadcrumbViewerLabelProvider
    extends BaseLabelProvider
    implements ITreePathLabelProvider {
        public void updateLabel(ViewerLabel label, TreePath elementPath) {
            Diagram lastSegment = (Diagram)elementPath.getLastSegment();
            NamedElement element = (NamedElement)lastSegment.getElement();
            AdapterFactoryLabelProvider provider = new AdapterFactoryLabelProvider((AdapterFactory)new SGraphItemProviderAdapterFactory());
            label.setText(provider.getText((Object)element));
            if (element instanceof Statechart) {
                label.setImage(StatechartImages.LOGO.image());
            } else {
                label.setImage(provider.getImage((Object)element));
            }
        }
    }

    public static class FilteringDiagramContextMenuProvider
    extends DiagramContextMenuProvider {
        protected String[] exclude = new String[]{"addNoteLinkAction", "properties", "org.eclipse.mylyn.context.ui.commands.attachment.retrieveContext", "org.eclipse.mylyn.resources.ui.ui.interest.remove.element", "formatMenu", "filtersMenu", "addGroup", "navigateGroup", "toolbarArrangeAllAction", "selectMenu", "diagramAddMenu", "navigateMenu", "viewGroup", "viewMenu"};

        protected FilteringDiagramContextMenuProvider(IWorkbenchPart part, EditPartViewer viewer) {
            super(part, viewer);
        }

        protected boolean allowItem(IContributionItem itemToAdd) {
            if (Arrays.contains((Object[])this.exclude, (Object)itemToAdd.getId())) {
                itemToAdd.setVisible(false);
            }
            return super.allowItem(itemToAdd);
        }
    }
}

