/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.ui.editor.dialogs;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.inject.Injector;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.internal.dialogs.NewWizard;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IGlobalScopeProvider;
import org.eclipse.xtext.scoping.IScope;
import org.yakindu.sct.model.sgraph.SGraphPackage;
import org.yakindu.sct.model.sgraph.Statechart;
import org.yakindu.sct.model.sgraph.ui.Activator;
import org.yakindu.sct.ui.editor.StatechartImages;

public class SelectSubmachineDialog
extends ElementListSelectionDialog {
    public static final int CLEAR_BUTTON = 1025;
    private boolean clearSelected = false;
    private EObject context;
    private final Resource resource;

    public SelectSubmachineDialog(Shell parent, Resource resource) {
        super(parent, SelectSubmachineDialog.getLabelProvider(resource));
        this.resource = resource;
        this.initDialog();
    }

    private static Injector getInjector(Resource resource) {
        return Activator.getDefault().getInjector();
    }

    private static ILabelProvider getLabelProvider(Resource resource) {
        return (ILabelProvider)SelectSubmachineDialog.getInjector(resource).getInstance(ILabelProvider.class);
    }

    private IGlobalScopeProvider getGlobalScopeProvider(Resource resource) {
        return (IGlobalScopeProvider)SelectSubmachineDialog.getInjector(resource).getInstance(IGlobalScopeProvider.class);
    }

    private Object[] getStatemachines(EObject context) {
        IScope scope = this.getGlobalScopeProvider(this.resource).getScope(context.eResource(), SGraphPackage.Literals.STATE__SUBSTATECHART, Predicates.alwaysTrue());
        Iterable statecharts = scope.getAllElements();
        return Iterables.toArray((Iterable)statecharts, IEObjectDescription.class);
    }

    protected void initDialog() {
        this.setTitle("Select Submachine");
        this.setMessage("Select the Submachine to include include into the Submachine State.");
        this.setImage(StatechartImages.LOGO.image());
        this.clearSelected = false;
    }

    public void setElements(Object[] elements) {
        EObject element;
        if (elements == null || elements.length != 1) {
            throw new IllegalStateException("No element was given");
        }
        Object object = elements[0];
        if (!(object instanceof EObject)) {
            throw new IllegalStateException("The element must be an EObject");
        }
        this.context = element = (EObject)object;
        super.setElements(this.getStatemachines(element));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, "None", false);
        super.createButtonsForButtonBar(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Link link = new Link(composite, 0);
        link.setText("Open the new project wizard to <a>create new statechart</a>.");
        link.addListener(13, (Listener)new OpenCreationWizardListener(this.getSelection()));
        return composite;
    }

    protected List getInitialElementSelections() {
        if (this.context instanceof Statechart) {
            return Collections.singletonList(this.context);
        }
        return super.getInitialElementSelections();
    }

    private IStructuredSelection getSelection() {
        QualifiedName selectedSubmachine = this.getSelectedSubmachine();
        if (selectedSubmachine != null) {
            return new StructuredSelection((Object)selectedSubmachine);
        }
        return StructuredSelection.EMPTY;
    }

    public QualifiedName getSelectedSubmachine() {
        Object[] result = this.getResult();
        if (result != null && result.length == 1) {
            QualifiedName statechart = null;
            if (result[0] instanceof IEObjectDescription) {
                statechart = ((IEObjectDescription)result[0]).getQualifiedName();
            }
            return statechart;
        }
        return null;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.clearPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void clearPressed() {
        this.clearSelected = true;
        this.setReturnCode(0);
        this.close();
    }

    public boolean isClearSelected() {
        return this.clearSelected;
    }

    protected static class OpenCreationWizardListener
    implements Listener {
        private final IStructuredSelection selection;

        public OpenCreationWizardListener(IStructuredSelection selection) {
            this.selection = selection;
        }

        public void handleEvent(Event event) {
            NewWizard wizard = new NewWizard();
            wizard.init(PlatformUI.getWorkbench(), this.selection);
            WizardDialog wd = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
            wd.setTitle(wizard.getWindowTitle());
            IDialogSettings workbenchSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
            IDialogSettings wizardSettings = workbenchSettings.getSection("NewWizardAction");
            if (wizardSettings == null) {
                wizardSettings = workbenchSettings.addNewSection("NewWizardAction");
            }
            wizard.setDialogSettings(wizardSettings);
            wizard.setForcePreviousAndNextButtons(true);
            wd.open();
        }
    }
}

