/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.ui.editor.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.BooleanValueStyle;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.yakindu.sct.ui.editor.editparts.StateEditPart;
import org.yakindu.sct.ui.editor.utils.GMFNotationUtil;

public class ToggleSubRegionLayoutCommand
extends AbstractHandler {
    private View view;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.view = this.unwrap(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.view);
        ToggleCommand toggleCommand = new ToggleCommand(editingDomain, this.view);
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)toggleCommand, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected View unwrap(ISelection selection) {
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object firstElement = structuredSelection.getFirstElement();
        if (firstElement == null) {
            return null;
        }
        return ((StateEditPart)((Object)firstElement)).getNotationView();
    }

    protected static class ToggleCommand
    extends AbstractTransactionalCommand {
        protected static final String TOGGLE_REGION_ALIGNMENT = "Toggle Region Alignment";
        protected View view;

        public ToggleCommand(TransactionalEditingDomain editingDomain, View view) {
            super(editingDomain, TOGGLE_REGION_ALIGNMENT, null);
            this.view = view;
        }

        public List getAffectedFiles() {
            if (this.view != null) {
                ArrayList<IFile> result = new ArrayList<IFile>();
                IFile file = WorkspaceSynchronizer.getFile((Resource)this.view.eResource());
                if (file != null) {
                    result.add(file);
                }
                return result;
            }
            return super.getAffectedFiles();
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            BooleanValueStyle style = GMFNotationUtil.getBooleanValueStyle(this.view, "isHorizontal");
            if (style == null) {
                style = NotationFactory.eINSTANCE.createBooleanValueStyle();
                style.setBooleanValue(true);
                style.setName("isHorizontal");
                this.view.getStyles().add((Object)style);
            } else {
                style.setBooleanValue(!style.isBooleanValue());
            }
            return CommandResult.newOKCommandResult((Object)this.view);
        }

        public String getLabel() {
            return TOGGLE_REGION_ALIGNMENT;
        }
    }
}

