/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.ui.editor.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.StringValueStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.yakindu.base.base.BasePackage;
import org.yakindu.sct.model.sgraph.SGraphPackage;
import org.yakindu.sct.ui.editor.utils.GMFNotationUtil;

public class ToggleShowDocumentationCommand
extends AbstractHandler {
    public static final String FEATURE_TO_SHOW = "featureToShow";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<View> views = this.unwrap(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        ToggleShowDocumentationCommand.toggleDocumentation(views);
        return null;
    }

    public static void toggleDocumentation(List<View> views) {
        CompositeCommand command = new CompositeCommand("toggle documentation");
        for (View view : views) {
            StringValueStyle style = GMFNotationUtil.getStringValueStyle(view, FEATURE_TO_SHOW);
            if (style == null) {
                style = ToggleShowDocumentationCommand.createInitialStyle(view);
            }
            String featureName = style.getStringValue().equals(SGraphPackage.Literals.SPECIFICATION_ELEMENT__SPECIFICATION.getName()) ? BasePackage.Literals.DOCUMENTED_ELEMENT__DOCUMENTATION.getName() : SGraphPackage.Literals.SPECIFICATION_ELEMENT__SPECIFICATION.getName();
            command.add((IUndoableOperation)new SetValueCommand(new SetRequest((EObject)style, (EStructuralFeature)NotationPackage.Literals.STRING_VALUE_STYLE__STRING_VALUE, (Object)featureName)));
        }
        ToggleShowDocumentationCommand.executeCommand((ICommand)command);
    }

    protected static StringValueStyle createInitialStyle(View view) {
        StringValueStyle style = NotationFactory.eINSTANCE.createStringValueStyle();
        style.setName(FEATURE_TO_SHOW);
        style.setStringValue(SGraphPackage.Literals.SPECIFICATION_ELEMENT__SPECIFICATION.getName());
        SetValueCommand cmd = new SetValueCommand(new SetRequest((EObject)view, (EStructuralFeature)NotationPackage.Literals.VIEW__STYLES, (Object)style));
        ToggleShowDocumentationCommand.executeCommand((ICommand)cmd);
        return style;
    }

    protected static void executeCommand(ICommand cmd) {
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)cmd, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    protected List<View> unwrap(ISelection selection) {
        ArrayList<View> result = new ArrayList<View>();
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        for (IGraphicalEditPart next : structuredSelection) {
            result.add(next.getNotationView());
        }
        return result;
    }
}

