/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtils {
    private static final Pattern SPLIT_PATTERN = Pattern.compile("([A-Z]+)");
    private static final Pattern PREFIX_PATTERN = Pattern.compile("[^A-Z][\\sA-Z]");
    private static final Pattern CONSTANT_PATTERN = Pattern.compile("[A-Z_]+");

    private StringUtils() {
    }

    public static String firstToLower(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        if (string.length() == 1) {
            return string.toLowerCase();
        }
        return String.valueOf(string.substring(0, 1).toLowerCase()) + string.substring(1);
    }

    public static String firstToUpper(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        if (string.length() == 1) {
            return string.toUpperCase();
        }
        return String.valueOf(string.substring(0, 1).toUpperCase()) + string.substring(1);
    }

    public static String split(String string) {
        String[] strings = StringUtils.splitByUpperCase(string);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < strings.length) {
            if (i > 0) {
                buffer.append(" ");
            }
            buffer.append(strings[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static String[] splitByUpperCase(String string) {
        Matcher matcher = SPLIT_PATTERN.matcher(string);
        int start = 0;
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            if (start < matcher.start()) {
                list.addAll(Arrays.asList(StringUtils.splitBySpace(string.substring(start, matcher.start()))));
            }
            if (matcher.group(1).length() == 1) {
                start = matcher.start();
                continue;
            }
            if (matcher.end(1) < string.length()) {
                list.addAll(Arrays.asList(StringUtils.splitBySpace(string.substring(matcher.start(), matcher.end(1) - 1))));
                start = matcher.end(1) - 1;
                continue;
            }
            list.addAll(Arrays.asList(StringUtils.splitBySpace(string.substring(matcher.start()))));
            start = string.length();
        }
        if (start < string.length()) {
            list.addAll(Arrays.asList(StringUtils.splitBySpace(string.substring(start))));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] splitBySpace(String string) {
        return string.split("\\s");
    }

    public static boolean hasSpaces(String string) {
        return string.indexOf(32) >= 0;
    }

    public static boolean isConstant(String string) {
        return CONSTANT_PATTERN.matcher(string).matches();
    }

    public static String[] allToLower(String[] strings, boolean includeFirst) {
        int start;
        int i = start = includeFirst ? 0 : 1;
        while (i < strings.length) {
            strings[i] = strings[i].toLowerCase();
            ++i;
        }
        return strings;
    }

    public static String getPrefix(String string) {
        Matcher matcher = PREFIX_PATTERN.matcher(string);
        int start = 0;
        String prefix = null;
        if (matcher.find()) {
            start = matcher.start() + 1;
            prefix = string.substring(0, start).trim();
        }
        return prefix;
    }

    public static String composeName(String prefix, String baseName, String suffix) {
        return !StringUtils.isEmpty(prefix) && Character.isLetter(prefix.charAt(prefix.length() - 1)) ? String.valueOf(prefix) + StringUtils.firstToUpper(baseName) + suffix : String.valueOf(prefix) + baseName + suffix;
    }

    public static String getLastElement(String path, char separator) {
        int index = path.lastIndexOf(separator);
        if (index < 0) {
            return path;
        }
        if (index >= path.length() - 1) {
            return "";
        }
        return path.substring(index + 1);
    }

    public static boolean startsWith(String string, String regexp) {
        return Pattern.compile("^" + regexp).matcher(string).find();
    }

    public static String checkNull(String string) {
        return string == null ? "" : string;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    public static String valueOf(Object object) {
        return object == null ? "" : object.toString();
    }

    public static int inferIndentationLevel(String reference, int tabSize) {
        StringBuffer expanded = new StringBuffer(StringUtils.expandTabs(reference, tabSize));
        int referenceWidth = expanded.length();
        if (tabSize == 0) {
            return referenceWidth;
        }
        int spaceWidth = 1;
        int level = referenceWidth / (tabSize * spaceWidth);
        if (referenceWidth % (tabSize * spaceWidth) > 0) {
            ++level;
        }
        return level;
    }

    public static String expandTabs(String string, int tabSize) {
        StringBuffer expanded = new StringBuffer();
        int i = 0;
        int n = string.length();
        int chars = 0;
        while (i < n) {
            char ch = string.charAt(i);
            if (ch == '\t') {
                while (chars < tabSize) {
                    expanded.append(' ');
                    ++chars;
                }
                chars = 0;
            } else {
                expanded.append(ch);
                if (++chars >= tabSize) {
                    chars = 0;
                }
            }
            ++i;
        }
        return expanded.toString();
    }
}

