/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.preferences.IMemberFilter;
import net.sf.jautodoc.source.SourceRange;
import net.sf.jautodoc.utils.StringUtils;
import net.sf.jautodoc.utils.Utils;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public final class SourceUtils {
    private static final Map<IJavaProject, List<String>> fieldPrefixes = new HashMap<IJavaProject, List<String>>();
    private static final Map<IJavaProject, List<String>> fieldSuffixes = new HashMap<IJavaProject, List<String>>();
    private static final FieldOptionChangeListener focListener = new FieldOptionChangeListener();

    private SourceUtils() {
    }

    public static ISourceReference getPackageOrImportReference(ICompilationUnit compUnit) throws JavaModelException {
        if (compUnit.getPackageDeclarations().length > 0) {
            return compUnit.getPackageDeclarations()[0];
        }
        if (compUnit.getImports().length > 0) {
            return compUnit.getImports()[0];
        }
        return null;
    }

    public static void getMembers(IType type, List<IMember> members, IMemberFilter filter) throws JavaModelException {
        SourceUtils.getFieldMembers(type, members, filter);
        SourceUtils.getMethodMembers(type, members, filter);
        SourceUtils.getNestedTypeMembers(type, members, filter);
    }

    public static void getFieldMembers(IType type, List<IMember> members, IMemberFilter filter) throws JavaModelException {
        IField[] fields = type.getFields();
        int i = 0;
        while (i < fields.length) {
            IField field = fields[i];
            if (SourceUtils.isMatchingField(field, filter)) {
                members.add((IMember)field);
            }
            ++i;
        }
    }

    public static void getMethodMembers(IType type, List<IMember> members, IMemberFilter filter) throws JavaModelException {
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            IMethod method = methods[i];
            if (SourceUtils.isMatchingMethod(method, filter)) {
                members.add((IMember)method);
            }
            ++i;
        }
    }

    public static void getNestedTypeMembers(IType type, List<IMember> members, IMemberFilter filter) throws JavaModelException {
        IType[] types = type.getTypes();
        int i = 0;
        while (i < types.length) {
            IType nestedType = types[i];
            if (SourceUtils.hasMatchingVisibility((IMember)nestedType, filter)) {
                if (filter.isIncludeTypes()) {
                    members.add((IMember)nestedType);
                }
                SourceUtils.getMembers(nestedType, members, filter);
            }
            ++i;
        }
    }

    public static void getSubpackages(IPackageFragment pkgFragment, Collection<IPackageFragment> subpackages) throws JavaModelException {
        String packageName = pkgFragment.getElementName();
        IJavaElement[] allPackages = ((IPackageFragmentRoot)pkgFragment.getParent()).getChildren();
        int i = 0;
        while (i < allPackages.length) {
            PackageFragment otherPackage = (PackageFragment)allPackages[i];
            String otherPackageName = otherPackage.getElementName();
            if (otherPackageName.length() > packageName.length() && otherPackageName.startsWith(packageName)) {
                subpackages.add((IPackageFragment)otherPackage);
            }
            ++i;
        }
    }

    public static boolean isMatchingType(IType type, IMemberFilter filter) throws JavaModelException {
        return filter.isIncludeTypes() && SourceUtils.hasMatchingVisibility((IMember)type, filter);
    }

    public static boolean isMatchingField(IField field, IMemberFilter filter) throws JavaModelException {
        return filter.isIncludeFields() && SourceUtils.hasMatchingVisibility((IMember)field, filter);
    }

    public static boolean isMatchingMethod(IMethod method, IMemberFilter filter) throws JavaModelException {
        return filter.isIncludeMethods() && SourceUtils.hasMatchingVisibility((IMember)method, filter) && SourceUtils.matchesGetterSetterFilter(method, filter);
    }

    public static boolean matchesGetterSetterFilter(IMethod method, IMemberFilter filter) throws JavaModelException {
        if (!filter.isGetterSetterOnly() && !filter.isExcludeGetterSetter()) {
            return true;
        }
        boolean isGetterSetter = SourceUtils.isGetterSetter(method);
        return filter.isGetterSetterOnly() && isGetterSetter || filter.isExcludeGetterSetter() && !isGetterSetter;
    }

    public static boolean isGetterSetter(IMember member) throws JavaModelException {
        return member instanceof IMethod && SourceUtils.isGetterSetter((IMethod)member, new StringBuffer());
    }

    public static boolean isGetterSetter(IMethod method) throws JavaModelException {
        return SourceUtils.isGetterSetter(method, new StringBuffer());
    }

    public static boolean isGetterSetter(IMethod method, StringBuffer fieldName) throws JavaModelException {
        String name = method.getElementName();
        String prefix = StringUtils.getPrefix(name);
        if ("set".equals(prefix) && name.length() > "set".length() && method.getParameterNames().length == 1 && method.getReturnType().charAt(0) == 'V') {
            fieldName.append(StringUtils.firstToLower(name.substring("set".length())));
            return true;
        }
        if ("get".equals(prefix) && name.length() > "get".length() && method.getParameterNames().length == 0 && method.getReturnType().charAt(0) != 'V') {
            fieldName.append(StringUtils.firstToLower(name.substring("get".length())));
            return true;
        }
        if ("is".equals(prefix) && name.length() > "is".length() && method.getParameterNames().length == 0 && method.getReturnType().charAt(0) == 'Z') {
            fieldName.append(StringUtils.firstToLower(name.substring("is".length())));
            return true;
        }
        return false;
    }

    public static IField getFieldOfGetterSetter(IMethod method) throws JavaModelException {
        StringBuffer fieldNameSb = new StringBuffer();
        if (!SourceUtils.isGetterSetter(method, fieldNameSb)) {
            return null;
        }
        String fieldName = fieldNameSb.toString();
        IType declaringType = method.getDeclaringType();
        for (String prefix : SourceUtils.getFieldPrefixes(method.getJavaProject())) {
            for (String suffix : SourceUtils.getFieldSuffixes(method.getJavaProject())) {
                IField field = declaringType.getField(StringUtils.composeName(prefix, fieldName, suffix));
                if (field == null || !field.exists()) continue;
                return field;
            }
        }
        return null;
    }

    public static boolean hasMatchingVisibility(IMember member, IMemberFilter filter) throws JavaModelException {
        int flags = member.getFlags();
        return filter.isIncludePublic() && Flags.isPublic((int)flags) || filter.isIncludeProtected() && Flags.isProtected((int)flags) || filter.isIncludePackage() && Flags.isPackageDefault((int)flags) || filter.isIncludePrivate() && Flags.isPrivate((int)flags);
    }

    public static ISourceRange findCommentSourceRange(IDocument document, int offset, int length, IScanner scanner, boolean onlyFirstComment) throws Exception {
        String delim;
        scanner.resetTo(offset, offset + length - 1);
        int commentStart = -1;
        int commentEnd = -1;
        boolean singleLineComment = false;
        int token = scanner.getNextToken();
        while (Utils.isComment(token)) {
            if (commentStart < 0) {
                commentStart = scanner.getCurrentTokenStartPosition();
            }
            commentEnd = scanner.getCurrentTokenEndPosition();
            singleLineComment = Utils.isSingleLineComment(token);
            if (onlyFirstComment) break;
            token = scanner.getNextToken();
        }
        if (commentStart < 0) {
            commentStart = offset;
            commentEnd = commentStart - 1;
        } else if (singleLineComment && (delim = document.getLineDelimiter(document.getLineOfOffset(commentEnd))) != null) {
            commentEnd -= delim.length();
        }
        return new SourceRange(commentStart, commentEnd - commentStart + 1);
    }

    public static ISourceRange findJavadocSourceRange(IMember member, IScanner scanner) throws JavaModelException, InvalidInputException {
        ISourceRange range = member.getSourceRange();
        int offset = range.getOffset();
        int length = range.getLength();
        scanner.resetTo(offset, offset + length - 1);
        int commentStart = -1;
        int commentEnd = -1;
        int token = scanner.getNextToken();
        while (Utils.isComment(token)) {
            if (Utils.isJavadocComment(token)) {
                commentStart = scanner.getCurrentTokenStartPosition();
                commentEnd = scanner.getCurrentTokenEndPosition();
                break;
            }
            token = scanner.getNextToken();
        }
        if (commentStart < 0) {
            commentStart = scanner.getCurrentTokenStartPosition();
            commentEnd = commentStart - 1;
        }
        return new SourceRange(commentStart, commentEnd - commentStart + 1);
    }

    public static boolean isSameComment(String existingJavadoc, String newJavadoc) {
        if (existingJavadoc == null || existingJavadoc.length() == 0) {
            return false;
        }
        return SourceUtils.getRawComment(existingJavadoc).equals(SourceUtils.getRawComment(newJavadoc));
    }

    public static String getRawComment(String javadoc) {
        String rawComment = "";
        if (javadoc != null) {
            rawComment = javadoc.replaceAll("[/\\*\\s]", "");
        }
        return rawComment;
    }

    public static String getInheritedJavadoc(IMethod method, String indent, String lineSeparator) throws JavaModelException {
        String javadoc = null;
        try {
            IMethod overridden = SourceUtils.findOverriddenMethod(method);
            if (overridden != null && (javadoc = CodeGeneration.getMethodComment((IMethod)method, (IMethod)overridden, (String)lineSeparator)) != null) {
                javadoc = SourceUtils.correctIndent(javadoc, indent, lineSeparator);
            }
        }
        catch (Exception e) {
            JAutodocPlugin.getDefault().handleException(e);
        }
        return javadoc;
    }

    public static IMethod findOverriddenMethod(IMethod method) {
        try {
            if (!method.isConstructor()) {
                IType declaringType = method.getDeclaringType();
                ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy((IType)declaringType);
                MethodOverrideTester tester = new MethodOverrideTester(declaringType, hierarchy);
                return tester.findOverriddenMethod(method, true);
            }
        }
        catch (JavaModelException e) {
            JAutodocPlugin.getDefault().handleException((Exception)((Object)e));
        }
        return null;
    }

    public static boolean isOverridingMethod(IMethod method) {
        return SourceUtils.findOverriddenMethod(method) != null;
    }

    public static String[] getParameterNames(IType type) throws JavaModelException {
        ITypeParameter[] typeParameters = type.getTypeParameters();
        String[] parameterNames = new String[typeParameters.length];
        SourceUtils.getTypeParameterNames(typeParameters, parameterNames);
        return parameterNames;
    }

    public static String[] getParameterNames(IMethod method) throws JavaModelException {
        ITypeParameter[] typeParameters = method.getTypeParameters();
        String[] methodParamNames = method.getParameterNames();
        String[] parameterNames = new String[typeParameters.length + methodParamNames.length];
        SourceUtils.getTypeParameterNames(typeParameters, parameterNames);
        int i = 0;
        while (i < methodParamNames.length) {
            parameterNames[typeParameters.length + i] = methodParamNames[i];
            ++i;
        }
        return parameterNames;
    }

    public static void getTypeParameterNames(ITypeParameter[] typeParameters, String[] parameterNames) {
        int i = 0;
        while (i < typeParameters.length) {
            parameterNames[i] = "<" + typeParameters[i].getElementName() + ">";
            ++i;
        }
    }

    public static String[] getExceptionTypes(IMethod method) throws JavaModelException {
        ArrayList<String> exceptionTypes = new ArrayList<String>();
        String[] stringArray = method.getExceptionTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String exception = stringArray[n2];
            exceptionTypes.add(Signature.getSignatureSimpleName((String)exception));
            ++n2;
        }
        return exceptionTypes.toArray(new String[exceptionTypes.size()]);
    }

    public static String correctIndent(String comment, String indent, String lineSeparator) throws BadLocationException {
        DefaultLineTracker tracker = new DefaultLineTracker();
        tracker.set(comment);
        int nLines = tracker.getNumberOfLines();
        if (nLines == 1) {
            return comment;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < nLines) {
            IRegion region = tracker.getLineInformation(i);
            int start = region.getOffset();
            int end = start + region.getLength();
            String line = comment.substring(start, end);
            if (i == 0) {
                buf.append(line);
            } else {
                buf.append(lineSeparator);
                buf.append(indent);
                buf.append(line);
            }
            ++i;
        }
        return buf.toString();
    }

    public static String getIndentionString(IDocument document, IMember member) throws Exception {
        StringBuffer indent = new StringBuffer();
        int pos = member.getSourceRange().getOffset();
        while (--pos >= 0) {
            char c = document.getChar(pos);
            if (c != '\t' && c != ' ') break;
            indent.append(c);
        }
        return indent.toString();
    }

    public static IType getFirstType(ICompilationUnit compUnit) throws JavaModelException {
        IType[] allTypes = compUnit.getAllTypes();
        return allTypes.length > 0 ? allTypes[0] : null;
    }

    public static IMember[] sortMembers(IMember[] members) throws JavaModelException {
        TreeMap<Integer, IMember> map = new TreeMap<Integer, IMember>();
        int i = 0;
        while (i < members.length) {
            IMember member = members[i];
            map.put(member.getSourceRange().getOffset(), member);
            ++i;
        }
        return map.values().toArray(new IMember[map.values().size()]);
    }

    private static List<String> getFieldPrefixes(IJavaProject javaProject) {
        return SourceUtils.getFieldOption(javaProject, fieldPrefixes, "org.eclipse.jdt.core.codeComplete.fieldPrefixes");
    }

    private static List<String> getFieldSuffixes(IJavaProject javaProject) {
        return SourceUtils.getFieldOption(javaProject, fieldSuffixes, "org.eclipse.jdt.core.codeComplete.fieldSuffixes");
    }

    private static List<String> getFieldOption(IJavaProject javaProject, Map<IJavaProject, List<String>> fieldOptions, String optionKey) {
        List<String> options = fieldOptions.get(javaProject);
        if (options == null) {
            options = new ArrayList<String>();
            options.add("");
            fieldOptions.put(javaProject, options);
            String sPrefixes = javaProject.getOption(optionKey, true);
            if (sPrefixes != null && sPrefixes.length() > 0) {
                options.addAll(Arrays.asList(sPrefixes.split(",")));
            }
            SourceUtils.addFieldOptionChangeListener(javaProject);
        }
        return options;
    }

    private static void addFieldOptionChangeListener(IJavaProject javaProject) {
        InstanceScope.INSTANCE.getNode("org.eclipse.jdt.core").addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)focListener);
        new ProjectScope(javaProject.getProject()).getNode("org.eclipse.jdt.core").addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)focListener);
    }

    private static final class FieldOptionChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private FieldOptionChangeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (event.getKey().equals("org.eclipse.jdt.core.codeComplete.fieldPrefixes") || event.getKey().equals("org.eclipse.jdt.core.codeComplete.fieldSuffixes")) {
                fieldPrefixes.clear();
                fieldSuffixes.clear();
            }
        }
    }
}

