/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.utils;

import org.eclipse.jface.text.rules.ICharacterScanner;

public class ResettableScanner
implements ICharacterScanner {
    private int readCount;
    private ICharacterScanner delegate;

    public ResettableScanner() {
        this.readCount = 0;
        this.delegate = null;
    }

    public ResettableScanner(ICharacterScanner scanner) {
        this.setScanner(scanner);
    }

    public void setScanner(ICharacterScanner scanner) {
        this.delegate = scanner;
        this.mark();
    }

    public int getColumn() {
        return this.delegate.getColumn();
    }

    public char[][] getLegalLineDelimiters() {
        return this.delegate.getLegalLineDelimiters();
    }

    public int read() {
        int ch = this.delegate.read();
        if (ch != -1) {
            ++this.readCount;
        }
        return ch;
    }

    public void unread() {
        if (this.readCount > 0) {
            --this.readCount;
        }
        this.delegate.unread();
    }

    public void mark() {
        this.readCount = 0;
    }

    public void reset() {
        while (this.readCount > 0) {
            this.unread();
        }
        while (this.readCount < 0) {
            this.read();
        }
    }

    public int getReadCount() {
        return this.readCount;
    }
}

