/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class NewFileOperation
extends WorkspaceModifyOperation {
    private IFile[] files;
    private String[] contents;

    public NewFileOperation(IFile[] files) {
        this(files, null);
    }

    public NewFileOperation(IFile[] files, String[] contents) {
        this.files = files;
        this.contents = contents;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        monitor.beginTask("Add Package Javadoc", this.files.length * 100);
        int i = 0;
        while (i < this.files.length) {
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            if (this.files[i].exists()) {
                monitor.worked(100);
            } else {
                this.createFile(this.files[i], this.contents[i], (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            }
            ++i;
        }
    }

    private void createFile(IFile file, String content, IProgressMonitor monitor) throws CoreException {
        try {
            file.create(this.getInputStream(content), false, monitor);
        }
        catch (CoreException e) {
            int code = e.getStatus().getCode();
            if (code == 268 || code == 272) {
                file.refreshLocal(0, null);
            }
            throw e;
        }
    }

    private InputStream getInputStream(String content) {
        if (content == null) {
            return null;
        }
        return new ByteArrayInputStream(content.getBytes());
    }
}

