/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates.wrapper;

import net.sf.jautodoc.templates.wrapper.AnnotationWrapper;
import net.sf.jautodoc.templates.wrapper.IMemberWrapper;
import net.sf.jautodoc.templates.wrapper.WrapperFactory;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public abstract class AbstractMemberWrapper
implements IMemberWrapper {
    protected int kind;
    protected IMember member;
    protected IMemberWrapper parent;

    protected AbstractMemberWrapper(IMember member, int kind) {
        this.kind = kind;
        this.member = member;
    }

    @Override
    public IMember getMember() {
        return this.member;
    }

    @Override
    public String getName() {
        return this.member.getElementName();
    }

    @Override
    public String getDeclaringType() throws JavaModelException {
        IType declaringType = this.member.getDeclaringType();
        return declaringType != null ? declaringType.getElementName() : "";
    }

    @Override
    public IMemberWrapper getParent() {
        if (this.parent == null && this.member.getParent() instanceof IMember) {
            this.parent = WrapperFactory.getWrapper((IMember)this.member.getParent());
        }
        return this.parent;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IMemberWrapper)) {
            return false;
        }
        return this.member.equals(((IMemberWrapper)obj).getMember());
    }

    @Override
    public boolean isStatic() throws JavaModelException {
        return Flags.isStatic((int)this.member.getFlags());
    }

    @Override
    public boolean isFinal() throws JavaModelException {
        return Flags.isFinal((int)this.member.getFlags());
    }

    @Override
    public boolean isConstructor() throws JavaModelException {
        return false;
    }

    @Override
    public boolean isMainMethod() throws JavaModelException {
        return false;
    }

    @Override
    public boolean isType() {
        return this.kind == 1;
    }

    @Override
    public boolean isField() {
        return this.kind == 2;
    }

    @Override
    public boolean isMethod() {
        return this.kind == 3;
    }

    @Override
    public boolean isParameter() {
        return this.kind == 4;
    }

    @Override
    public boolean isException() {
        return this.kind == 5;
    }

    @Override
    public AnnotationWrapper getAnnotation(String name) throws JavaModelException {
        if (this.member instanceof IAnnotatable) {
            IAnnotatable annotatable = (IAnnotatable)this.member;
            IAnnotation[] iAnnotationArray = annotatable.getAnnotations();
            int n = iAnnotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation annotation = iAnnotationArray[n2];
                if (annotation.getElementName().equals(name)) {
                    return new AnnotationWrapper(annotation);
                }
                ++n2;
            }
        }
        return new AnnotationWrapper();
    }
}

