/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates.velocity.rules;

import net.sf.jautodoc.templates.velocity.rules.IdentifierDetector;
import net.sf.jautodoc.utils.ResettableScanner;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.SingleLineRule;

public class ReferenceRule
extends SingleLineRule {
    private static IdentifierDetector detector = new IdentifierDetector();
    private ResettableScanner rScanner = new ResettableScanner();
    private int parenthesisStack = 0;
    private int braceStack = 0;
    private char lastQuote = (char)32;
    private boolean inString = false;
    private boolean seenChar = false;
    private boolean allowIncompleteReferences = false;
    private StringBuffer sb = new StringBuffer();

    public ReferenceRule(String start, IToken token) {
        this(start, token, false);
    }

    public ReferenceRule(String startSequence, IToken token, boolean allowIncompleteReferences) {
        super(startSequence, null, token);
        this.allowIncompleteReferences = allowIncompleteReferences;
    }

    protected boolean endSequenceDetected(ICharacterScanner scanner) {
        this.rScanner.setScanner(scanner);
        this.parenthesisStack = 0;
        this.braceStack = 0;
        this.lastQuote = (char)32;
        this.inString = false;
        this.seenChar = false;
        this.sb.setLength(0);
        while (true) {
            int i = this.rScanner.read();
            char c = (char)i;
            if (i == -1 || c == '\r' || c == '\n') {
                if (!this.isValid(this.rScanner, true)) break;
                return true;
            }
            if (Character.isWhitespace(c)) {
                if (this.isValid(this.rScanner, true)) {
                    return true;
                }
                if (!this.inString && this.parenthesisStack == 0) {
                    break;
                }
            } else if (c == '\'' || c == '\"') {
                if (this.parenthesisStack == 0) break;
                if (this.inString) {
                    if (this.lastQuote == c) {
                        this.lastQuote = (char)32;
                        this.inString = false;
                    }
                } else {
                    this.lastQuote = c;
                    this.inString = true;
                }
            } else if (c == '(') {
                if (!this.inString) {
                    ++this.parenthesisStack;
                }
            } else if (c == ')') {
                if (!this.inString) {
                    --this.parenthesisStack;
                    if (this.parenthesisStack < 0) {
                        if (!this.isValid(this.rScanner, true)) break;
                        return true;
                    }
                }
            } else if (c == '{') {
                if (!this.inString) {
                    if (this.rScanner.getReadCount() != 1) break;
                    ++this.braceStack;
                }
            } else if (c == '}') {
                if (!this.inString) {
                    --this.braceStack;
                    if (this.braceStack < 0) break;
                    if (this.braceStack == 0) {
                        if (!this.isValid(this.rScanner, false)) break;
                        return true;
                    }
                }
            } else if (c == ',') {
                if (!this.inString && this.parenthesisStack == 0) {
                    break;
                }
            } else if (this.rScanner.getReadCount() == 1 && this.braceStack == 0 || this.rScanner.getReadCount() == 2 && this.braceStack == 1) {
                if (!detector.isWordStart(c)) break;
                this.seenChar = true;
            } else {
                if (!this.seenChar) break;
                if (!detector.isWordPart(c)) {
                    if (!this.isValid(this.rScanner, true)) break;
                    return true;
                }
            }
            this.sb.append(c);
        }
        this.rScanner.reset();
        return false;
    }

    private boolean isValid(ICharacterScanner scanner, boolean unread) {
        if (!this.allowIncompleteReferences) {
            if (!this.inString && this.seenChar && this.braceStack == 0 && this.parenthesisStack <= 0) {
                if (unread) {
                    scanner.unread();
                }
                return true;
            }
        } else if (this.braceStack >= 0) {
            if (unread) {
                scanner.unread();
            }
            return true;
        }
        return false;
    }
}

