/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates.velocity.contentassist;

import java.util.Map;
import net.sf.jautodoc.ResourceManager;
import net.sf.jautodoc.templates.rules.IRulesStrategy;
import net.sf.jautodoc.templates.rules.TemplateCodeScanner;
import net.sf.jautodoc.templates.velocity.contentassist.ReferenceManager;
import net.sf.jautodoc.templates.velocity.rules.StartingReferenceRulesStrategie;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;

public class ReferenceTextHover
implements ITextHover {
    private Map<String, String> properties;
    private ITokenScanner referenceScanner;

    public ReferenceTextHover(Map<String, String> properties) {
        IRulesStrategy[] rulesStrategies = new IRulesStrategy[]{new StartingReferenceRulesStrategie()};
        this.referenceScanner = new TemplateCodeScanner(rulesStrategies);
        this.properties = properties;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String info = null;
        try {
            info = ReferenceManager.getElementDescription(textViewer.getDocument().get(hoverRegion.getOffset(), hoverRegion.getLength()), this.properties);
        }
        catch (Exception exception) {}
        return info;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        IRegion region = null;
        try {
            region = this.getElementRegion(textViewer.getDocument(), offset);
        }
        catch (Exception exception) {}
        return region;
    }

    private IRegion getElementRegion(IDocument document, int offset) throws BadLocationException {
        int elementEnd;
        if (offset == document.getLength()) {
            return null;
        }
        IRegion lineInfo = document.getLineInformationOfOffset(offset);
        int lineOffset = lineInfo.getOffset();
        int referenceOffset = offset;
        while (lineOffset <= referenceOffset) {
            if (document.getChar(referenceOffset) == '$') break;
            --referenceOffset;
        }
        if (referenceOffset < lineOffset) {
            return null;
        }
        int length = lineInfo.getLength() - (referenceOffset - lineOffset);
        this.referenceScanner.setRange(document, referenceOffset, length);
        IToken token = this.referenceScanner.nextToken();
        if (!token.equals(ResourceManager.getToken("reference"))) {
            return null;
        }
        int elementStart = this.getElementStart(document, offset);
        if (elementStart < (elementEnd = this.getElementEnd(document, offset))) {
            return new Region(elementStart, elementEnd - elementStart);
        }
        return null;
    }

    private int getElementStart(IDocument document, int offset) throws BadLocationException {
        int elementStart = offset;
        while (this.referenceScanner.getTokenOffset() <= elementStart) {
            char ch = document.getChar(elementStart);
            if (ch == '$' || ch == '!' || ch == '{' || ch == '.') {
                ++elementStart;
                break;
            }
            --elementStart;
        }
        return elementStart;
    }

    private int getElementEnd(IDocument document, int offset) throws BadLocationException {
        int elementEnd = offset;
        int referenceEnd = this.referenceScanner.getTokenOffset() + this.referenceScanner.getTokenLength();
        while (elementEnd < referenceEnd) {
            char ch = document.getChar(elementEnd);
            if (ch == '!' || ch == '{' || ch == '}' || ch == '.') break;
            ++elementEnd;
        }
        return elementEnd;
    }
}

