/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates.velocity.contentassist;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.jautodoc.templates.contentassist.ElementProposal;
import net.sf.jautodoc.templates.contentassist.FunctionProposal;
import net.sf.jautodoc.templates.contentassist.TemplateProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Point;

public class ReferenceManager {
    private static final List<ElementProposal> REFERENCE_PROPOSALS = new ArrayList<ElementProposal>();
    private static final List<ElementProposal> BASE_PROPERTIES = new ArrayList<ElementProposal>();
    private static final ElementProposal ELEMENT = new ElementProposal("e", "e - ", "The matching element", -1);
    private static final ElementProposal PROPERTIES = new ElementProposal("p.get('')", "p - ", "Get system property", -3);
    private static final FunctionProposal GROUP = new FunctionProposal("g(1)", "g(n) - ", "Group with index n", "g\\(\\d*\\)", -3, 1, false);
    private static final FunctionProposal SPLIT = new FunctionProposal("s()", "s()    - ", "Split string", -1);
    private static final FunctionProposal REPLACE = new FunctionProposal("r()", "r()    - ", "Replace prefix", -1);
    private static final FunctionProposal REPLACE_SPLIT = new FunctionProposal("rs()", "rs()   - ", "Replace prefix, split string", -1);
    private static final FunctionProposal REPLACE_SPLIT_UPPER = new FunctionProposal("rsfu()", "rsfu() - ", "Replace prefix, split string, first to upper", -1);
    private static final FunctionProposal REPLACE_SPLIT_LOWER = new FunctionProposal("rsfl()", "rsfl() - ", "Replace prefix, split string, first to lower", -1);
    private static final FunctionProposal LOWER = new FunctionProposal("fl()", "fl()    - ", "First to lower", -1);
    private static final FunctionProposal UPPER = new FunctionProposal("fu()", "fu()   - ", "First to upper", -1);
    private static final FunctionProposal SPLIT_LOWER = new FunctionProposal("sfl()", "sfl()  - ", "Split string, first to lower", -1);
    private static final FunctionProposal SPLIT_UPPER = new FunctionProposal("sfu()", "sfu() - ", "Split string, first to upper", -1);
    private static final FunctionProposal PARENT = new FunctionProposal("p()", "p()    - ", "Matching parent element", -1, true);
    private static final FunctionProposal TYPE = new FunctionProposal("getType()", "getType() - ", "Get element type", -1, true);
    private static final FunctionProposal DECLARING_TYPE = new FunctionProposal("getDeclaringType()", "getDeclaringType() - ", "Get declaring type", -1, true);
    private static final FunctionProposal STATIC = new FunctionProposal("isStatic()", "isStatic() - ", "True, if static element", -1, true);
    private static final FunctionProposal FINAL = new FunctionProposal("isFinal()", "isFinal() - ", "True, if final element", -1, true);
    private static final FunctionProposal LENGTH = new FunctionProposal("length()", "length() - ", "Length of string", -1);
    private static final FunctionProposal CHAR_AT = new FunctionProposal("charAt(0)", "charAt(n) - ", "Char at index n", "charAt\\(\\d*\\)", -3, 1, false);
    private static final FunctionProposal IS_UPPER = new FunctionProposal("isUpperCase()", "isUpperCase()", "", -1);
    private static final FunctionProposal IS_LOWER = new FunctionProposal("isLowerCase()", "isLowerCase()", "", -1);
    private static final FunctionProposal IS_LETTER = new FunctionProposal("isLetter()", "isLetter()", "", -1);
    private static final FunctionProposal IS_DIGIT = new FunctionProposal("isDigit()", "isDigit()", "", -1);
    private static final FunctionProposal IS_LETTER_OR_DIGIT = new FunctionProposal("isLetterOrDigit()", "isLetterOrDigit()", "", -1);
    private static final FunctionProposal HAS_ANNOTATION = new FunctionProposal("hasAnnotation('name')", "hasAnnotation('name') - ", "Check for annotation by name", "hasAnnotation\\('.*'\\)", -7, 4, false);
    private static final FunctionProposal GET_ANNOTATION = new FunctionProposal("getAnnotation('name')", "getAnnotation('name') - ", "Get annotation by name", "getAnnotation\\('.*'\\)", -7, 4, false);
    private static final FunctionProposal GET_ANNOTATION_VALUE = new FunctionProposal("getValue('key')", "getValue('key') - ", "Get annotation value by key", "getValue\\('.*'\\)", -6, 3, false);

    static {
        PARENT.addPredecessor(ELEMENT);
        PARENT.addPredecessor(PARENT);
        GROUP.addPredecessor(ELEMENT);
        GROUP.addPredecessor(PARENT);
        TYPE.addPredecessor(ELEMENT);
        TYPE.addPredecessor(PARENT);
        DECLARING_TYPE.addPredecessor(ELEMENT);
        DECLARING_TYPE.addPredecessor(PARENT);
        STATIC.addPredecessor(ELEMENT);
        STATIC.addPredecessor(PARENT);
        FINAL.addPredecessor(ELEMENT);
        FINAL.addPredecessor(PARENT);
        HAS_ANNOTATION.addPredecessor(ELEMENT);
        HAS_ANNOTATION.addPredecessor(PARENT);
        GET_ANNOTATION.addPredecessor(ELEMENT);
        GET_ANNOTATION.addPredecessor(PARENT);
        GET_ANNOTATION_VALUE.addPredecessor(GET_ANNOTATION);
        CHAR_AT.addPredecessor(ELEMENT);
        CHAR_AT.addPredecessor(PARENT);
        CHAR_AT.addPredecessor(GROUP);
        CHAR_AT.addPredecessor(TYPE);
        CHAR_AT.addPredecessor(DECLARING_TYPE);
        LENGTH.addPredecessor(ELEMENT);
        LENGTH.addPredecessor(PARENT);
        LENGTH.addPredecessor(GROUP);
        LENGTH.addPredecessor(TYPE);
        LENGTH.addPredecessor(DECLARING_TYPE);
        SPLIT.addPredecessor(ELEMENT);
        SPLIT.addPredecessor(PARENT);
        SPLIT.addPredecessor(GROUP);
        SPLIT.addPredecessor(REPLACE);
        SPLIT.addPredecessor(LOWER);
        SPLIT.addPredecessor(UPPER);
        SPLIT.addPredecessor(TYPE);
        SPLIT.addPredecessor(DECLARING_TYPE);
        REPLACE.addPredecessor(ELEMENT);
        REPLACE.addPredecessor(PARENT);
        REPLACE.addPredecessor(GROUP);
        REPLACE.addPredecessor(SPLIT);
        REPLACE.addPredecessor(LOWER);
        REPLACE.addPredecessor(UPPER);
        REPLACE.addPredecessor(SPLIT_LOWER);
        REPLACE.addPredecessor(SPLIT_UPPER);
        REPLACE.addPredecessor(TYPE);
        REPLACE.addPredecessor(DECLARING_TYPE);
        REPLACE_SPLIT.addPredecessor(ELEMENT);
        REPLACE_SPLIT.addPredecessor(PARENT);
        REPLACE_SPLIT.addPredecessor(GROUP);
        REPLACE_SPLIT.addPredecessor(LOWER);
        REPLACE_SPLIT.addPredecessor(UPPER);
        REPLACE_SPLIT.addPredecessor(TYPE);
        REPLACE_SPLIT.addPredecessor(DECLARING_TYPE);
        REPLACE_SPLIT_UPPER.addPredecessor(ELEMENT);
        REPLACE_SPLIT_UPPER.addPredecessor(PARENT);
        REPLACE_SPLIT_UPPER.addPredecessor(GROUP);
        REPLACE_SPLIT_UPPER.addPredecessor(TYPE);
        REPLACE_SPLIT_UPPER.addPredecessor(DECLARING_TYPE);
        REPLACE_SPLIT_LOWER.addPredecessor(ELEMENT);
        REPLACE_SPLIT_LOWER.addPredecessor(PARENT);
        REPLACE_SPLIT_LOWER.addPredecessor(GROUP);
        REPLACE_SPLIT_LOWER.addPredecessor(TYPE);
        REPLACE_SPLIT_LOWER.addPredecessor(DECLARING_TYPE);
        LOWER.addPredecessor(ELEMENT);
        LOWER.addPredecessor(PARENT);
        LOWER.addPredecessor(GROUP);
        LOWER.addPredecessor(SPLIT);
        LOWER.addPredecessor(REPLACE);
        LOWER.addPredecessor(REPLACE_SPLIT);
        LOWER.addPredecessor(TYPE);
        LOWER.addPredecessor(DECLARING_TYPE);
        UPPER.addPredecessor(ELEMENT);
        UPPER.addPredecessor(PARENT);
        UPPER.addPredecessor(GROUP);
        UPPER.addPredecessor(SPLIT);
        UPPER.addPredecessor(REPLACE);
        UPPER.addPredecessor(REPLACE_SPLIT);
        UPPER.addPredecessor(TYPE);
        UPPER.addPredecessor(DECLARING_TYPE);
        SPLIT_LOWER.addPredecessor(ELEMENT);
        SPLIT_LOWER.addPredecessor(PARENT);
        SPLIT_LOWER.addPredecessor(GROUP);
        SPLIT_LOWER.addPredecessor(REPLACE);
        SPLIT_LOWER.addPredecessor(TYPE);
        SPLIT_LOWER.addPredecessor(DECLARING_TYPE);
        SPLIT_UPPER.addPredecessor(ELEMENT);
        SPLIT_UPPER.addPredecessor(PARENT);
        SPLIT_UPPER.addPredecessor(GROUP);
        SPLIT_UPPER.addPredecessor(REPLACE);
        SPLIT_UPPER.addPredecessor(TYPE);
        SPLIT_UPPER.addPredecessor(DECLARING_TYPE);
        IS_UPPER.addPredecessor(CHAR_AT);
        IS_LOWER.addPredecessor(CHAR_AT);
        IS_LETTER.addPredecessor(CHAR_AT);
        IS_DIGIT.addPredecessor(CHAR_AT);
        IS_LETTER_OR_DIGIT.addPredecessor(CHAR_AT);
        REFERENCE_PROPOSALS.add(ELEMENT);
        REFERENCE_PROPOSALS.add(GROUP);
        REFERENCE_PROPOSALS.add(SPLIT);
        REFERENCE_PROPOSALS.add(REPLACE);
        REFERENCE_PROPOSALS.add(REPLACE_SPLIT);
        REFERENCE_PROPOSALS.add(REPLACE_SPLIT_UPPER);
        REFERENCE_PROPOSALS.add(REPLACE_SPLIT_LOWER);
        REFERENCE_PROPOSALS.add(LOWER);
        REFERENCE_PROPOSALS.add(UPPER);
        REFERENCE_PROPOSALS.add(SPLIT_LOWER);
        REFERENCE_PROPOSALS.add(SPLIT_UPPER);
        REFERENCE_PROPOSALS.add(PARENT);
        REFERENCE_PROPOSALS.add(TYPE);
        REFERENCE_PROPOSALS.add(DECLARING_TYPE);
        REFERENCE_PROPOSALS.add(STATIC);
        REFERENCE_PROPOSALS.add(FINAL);
        REFERENCE_PROPOSALS.add(LENGTH);
        REFERENCE_PROPOSALS.add(CHAR_AT);
        REFERENCE_PROPOSALS.add(IS_UPPER);
        REFERENCE_PROPOSALS.add(IS_LOWER);
        REFERENCE_PROPOSALS.add(IS_LETTER);
        REFERENCE_PROPOSALS.add(IS_DIGIT);
        REFERENCE_PROPOSALS.add(IS_LETTER_OR_DIGIT);
        REFERENCE_PROPOSALS.add(HAS_ANNOTATION);
        REFERENCE_PROPOSALS.add(GET_ANNOTATION);
        REFERENCE_PROPOSALS.add(GET_ANNOTATION_VALUE);
        BASE_PROPERTIES.add(new ElementProposal("user", "user - ", "Current user"));
        BASE_PROPERTIES.add(new ElementProposal("date", "date - ", "Current date"));
        BASE_PROPERTIES.add(new ElementProposal("time", "time - ", "Current time"));
        BASE_PROPERTIES.add(new ElementProposal("year", "year - ", "Current year"));
        BASE_PROPERTIES.add(new ElementProposal("project_name", "project_name - ", "Project name"));
        BASE_PROPERTIES.add(new ElementProposal("package_name", "package_name - ", "Package name"));
        BASE_PROPERTIES.add(new ElementProposal("file_name", "file_name    - ", "File name"));
        BASE_PROPERTIES.add(new ElementProposal("type_name", "type_name    - ", "Primary type name"));
    }

    public static List<ICompletionProposal> getCompletionProposals(String element, int offset, int length, Map<String, String> properties, boolean propertiesOnly) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        boolean silent = false;
        if (element.startsWith("$!{")) {
            silent = true;
            element = element.substring(3);
        } else if (element.startsWith("$!")) {
            silent = true;
            element = element.substring(2);
        } else if (element.startsWith("${")) {
            element = element.substring(2);
        } else if (element.startsWith("$")) {
            element = element.substring(1);
        } else {
            return proposals;
        }
        if (element.indexOf(46) == -1) {
            return ReferenceManager.getElementProposals(element, offset, length, silent, properties, propertiesOnly);
        }
        if (!propertiesOnly) {
            return ReferenceManager.getFunctionProposals(element, offset, length, silent);
        }
        return proposals;
    }

    public static String getElementDescription(String element, Map<String, String> properties) {
        ElementProposal referenceProposal = ReferenceManager.getMatchingProposal(element, REFERENCE_PROPOSALS);
        if (referenceProposal != null) {
            return referenceProposal.getDescription();
        }
        referenceProposal = ReferenceManager.getMatchingProposal(element, BASE_PROPERTIES);
        if (referenceProposal != null) {
            return referenceProposal.getDescription();
        }
        return properties.get(element);
    }

    private static List<ICompletionProposal> getElementProposals(String element, int offset, int length, boolean silent, Map<String, String> properties, boolean propertiesOnly) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        if (!propertiesOnly && (element.length() == 0 || ELEMENT.getProposal().startsWith(element))) {
            proposals.add(ReferenceManager.createTemplateProposal(ELEMENT, offset, length, silent));
        }
        if (element.length() == 0 || PROPERTIES.getProposal().startsWith(element)) {
            proposals.add(ReferenceManager.createTemplateProposal(PROPERTIES, offset, length, silent));
        }
        for (ElementProposal propertyProposal : BASE_PROPERTIES) {
            if (element.length() != 0 && !propertyProposal.getProposal().startsWith(element)) continue;
            proposals.add(ReferenceManager.createTemplateProposal(propertyProposal, offset, length, silent));
        }
        for (String key : new TreeSet<String>(properties.keySet())) {
            if (element.length() != 0 && !key.startsWith(element)) continue;
            proposals.add(ReferenceManager.createTemplateProposal(new ElementProposal(key, String.valueOf(key) + " - ", "Property"), offset, length, silent));
        }
        return proposals;
    }

    private static List<ICompletionProposal> getFunctionProposals(String element, int offset, int length, boolean silent) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        String[] tokens = element.split("\\.");
        if (tokens.length == 0 || !tokens[0].equals("e")) {
            return proposals;
        }
        int level = element.endsWith(".") ? tokens.length : tokens.length - 1;
        Set<FunctionProposal> functionProposals = ReferenceManager.getValidFunctionProposals(ReferenceManager.getMatchingProposal(tokens[level - 1], REFERENCE_PROPOSALS));
        int i = 1;
        while (i < level - 1) {
            ElementProposal rp = ReferenceManager.getMatchingProposal(tokens[i], REFERENCE_PROPOSALS);
            if (rp == null) {
                return proposals;
            }
            if (!rp.isMultiple()) {
                functionProposals.remove(rp);
            }
            ++i;
        }
        String functionStart = element.endsWith(".") ? "" : tokens[tokens.length - 1];
        for (FunctionProposal function : functionProposals) {
            if (functionStart.length() != 0 && !function.getProposal().startsWith(functionStart)) continue;
            String elementStart = element.substring(0, element.lastIndexOf(46));
            proposals.add(ReferenceManager.createTemplateProposal(String.valueOf(elementStart) + ".", function, offset, length, silent));
        }
        return proposals;
    }

    private static Set<FunctionProposal> getValidFunctionProposals(ElementProposal predecessor) {
        LinkedHashSet<FunctionProposal> functionProposals = new LinkedHashSet<FunctionProposal>();
        if (predecessor == null) {
            return functionProposals;
        }
        for (ElementProposal fp : REFERENCE_PROPOSALS) {
            if (!(fp instanceof FunctionProposal) || !((FunctionProposal)fp).isPredecessor(predecessor)) continue;
            functionProposals.add((FunctionProposal)fp);
        }
        return functionProposals;
    }

    private static ElementProposal getMatchingProposal(String token, List<ElementProposal> proposals) {
        ElementProposal referenceProposal = null;
        for (ElementProposal fp : proposals) {
            if (!fp.matches(token)) continue;
            referenceProposal = fp;
            break;
        }
        return referenceProposal;
    }

    private static String createReferenceString(String element, boolean silent) {
        return String.valueOf(silent ? "$!{" : "${") + element + "}";
    }

    private static TemplateProposal createTemplateProposal(ElementProposal referenceProposal, int offset, int length, boolean silent) {
        return ReferenceManager.createTemplateProposal("", referenceProposal, offset, length, silent);
    }

    private static TemplateProposal createTemplateProposal(String prefix, ElementProposal referenceProposal, int offset, int length, boolean silent) {
        String proposal = ReferenceManager.createReferenceString(String.valueOf(prefix) + referenceProposal.getProposal(), silent);
        return new TemplateProposal(proposal, referenceProposal.getDisplayString(), offset, length, new Point(offset + proposal.length() + referenceProposal.getSelectionOffset(), referenceProposal.getSelectionLength()));
    }
}

