/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates.velocity.contentassist;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jautodoc.ResourceManager;
import net.sf.jautodoc.templates.contentassist.AbstractTemplateContentAssistant;
import net.sf.jautodoc.templates.rules.IRulesStrategy;
import net.sf.jautodoc.templates.rules.TemplateCodeScanner;
import net.sf.jautodoc.templates.velocity.contentassist.ReferenceManager;
import net.sf.jautodoc.templates.velocity.rules.StartingReferenceRulesStrategie;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;

public class ReferenceContentAssistant
extends AbstractTemplateContentAssistant {
    private Map<String, String> properties;
    private boolean propertiesOnly;
    private ITokenScanner referenceScanner;

    public ReferenceContentAssistant(Map<String, String> properties, boolean propertiesOnly) {
        char[] cArray;
        String[] stringArray = new String[]{"$"};
        if (propertiesOnly) {
            char[] cArray2 = new char[1];
            cArray = cArray2;
            cArray2[0] = 36;
        } else {
            char[] cArray3 = new char[2];
            cArray3[0] = 36;
            cArray = cArray3;
            cArray3[1] = 46;
        }
        super(stringArray, cArray);
        this.properties = properties;
        this.propertiesOnly = propertiesOnly;
        IRulesStrategy[] ruleStrategies = new IRulesStrategy[]{new StartingReferenceRulesStrategie()};
        this.referenceScanner = new TemplateCodeScanner(ruleStrategies);
    }

    @Override
    public List<ICompletionProposal> getCompletionProposals(IDocument document, int offset, int length) {
        try {
            String element = this.getElement(document, offset, length);
            if (element != null) {
                return ReferenceManager.getCompletionProposals(element, offset, length, this.properties, this.propertiesOnly);
            }
        }
        catch (Exception exception) {}
        return new ArrayList<ICompletionProposal>();
    }

    private String getElement(IDocument document, int offset, int length) throws BadLocationException {
        if (length <= 0 || offset > 0 && document.getChar(offset - 1) == '\\') {
            return null;
        }
        String element = document.get(offset, length);
        if (element.startsWith("$") && this.isValidReference(document, offset, length)) {
            return element;
        }
        return null;
    }

    private boolean isValidReference(IDocument document, int offset, int length) {
        this.referenceScanner.setRange(document, offset, length);
        IToken token = this.referenceScanner.nextToken();
        return this.referenceScanner.getTokenOffset() == offset && this.referenceScanner.getTokenLength() == length && token.equals(ResourceManager.getToken("reference"));
    }
}

