/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates.velocity.contentassist;

import java.util.ArrayList;
import java.util.List;
import net.sf.jautodoc.templates.contentassist.AbstractTemplateContentAssistant;
import net.sf.jautodoc.templates.velocity.contentassist.DirectiveManager;
import net.sf.jautodoc.templates.velocity.rules.DirectiveDetector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class DirectiveContentAssistant
extends AbstractTemplateContentAssistant {
    private DirectiveDetector directiveDetector = new DirectiveDetector();

    public DirectiveContentAssistant() {
        super(new String[]{"#"}, new char[]{'#'});
    }

    @Override
    public List<ICompletionProposal> getCompletionProposals(IDocument document, int offset, int length) {
        try {
            String element = this.getElement(document, offset, length);
            if (element != null) {
                return DirectiveManager.getCompletionProposals(element, offset, length);
            }
        }
        catch (Exception exception) {}
        return new ArrayList<ICompletionProposal>();
    }

    private String getElement(IDocument document, int offset, int length) throws BadLocationException {
        if (length <= 0 || offset > 0 && document.getChar(offset - 1) == '\\') {
            return null;
        }
        String element = document.get(offset, length);
        if (element.startsWith("#") && this.isValidElement(element)) {
            return element;
        }
        return null;
    }

    private boolean isValidElement(String element) {
        char[] chars = element.toCharArray();
        if (chars.length == 0 || !this.directiveDetector.isWordStart(chars[0])) {
            return false;
        }
        int i = 1;
        while (i < chars.length) {
            if (!this.directiveDetector.isWordPart(chars[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

