/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates.velocity;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jautodoc.templates.LogEntry;
import net.sf.jautodoc.templates.TemplateEngineLogger;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;

public class VelocityLogger
extends TemplateEngineLogger
implements LogChute {
    private static final Pattern PATTERN = Pattern.compile("line\\s+(\\d+).+column\\s+(\\d+)");
    private int level;
    private LogEntry logEntry;

    public void init(RuntimeServices rs) throws Exception {
        this.level = rs.getInt("runtime.log.logsystem.jautodoc.level", 2);
        this.logEntry = new LogEntry();
    }

    public boolean isLevelEnabled(int level) {
        return this.level <= level;
    }

    public void log(int level, String message) {
        this.log(level, message, null);
    }

    public void log(int level, String message, Throwable throwable) {
        if (this.isLevelEnabled(level)) {
            this.parseLocation(message, this.logEntry);
            this.logEntry.setSeverity(this.getSeverity(level));
            this.logEntry.setMessage(message);
            this.logEntry.setThrowable(throwable);
            this.logMessage(this.logEntry);
        }
    }

    private int getSeverity(int level) {
        return level == 3 ? 4 : (level == 2 ? 2 : (level == 1 ? 1 : 0));
    }

    private void parseLocation(String message, LogEntry logEntry) {
        Matcher matcher = PATTERN.matcher(message);
        if (matcher.find()) {
            logEntry.setLine(Integer.parseInt(matcher.group(1)) - 1);
            logEntry.setColumn(Integer.parseInt(matcher.group(2)) - 1);
        } else {
            logEntry.setLine(-1);
            logEntry.setColumn(-1);
        }
    }
}

