/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.templates;

import com.megginson.sax.DataWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.util.List;
import javax.xml.parsers.SAXParserFactory;
import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.preferences.Constants;
import net.sf.jautodoc.templates.TemplateEntry;
import net.sf.jautodoc.templates.TemplateSet;
import net.sf.jautodoc.utils.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class TemplateSerializer
implements Constants {
    private static final String TEMPLATE_ROOT = "templates";
    private static final String TEMPLATE_ENTRY = "template";
    private static final String TEMPLATE_NAME = "name";
    private static final String TEMPLATE_KIND = "kind";
    private static final String TEMPLATE_SIGNATURE = "signature";
    private static final String TEMPLATE_DEFAULT = "default";
    private static final String TEMPLATE_REGEX = "regex";
    private static final String TEMPLATE_TEXT = "text";
    private static final String TEMPLATE_EXAMPLE = "example";

    public static TemplateSet loadTemplates(File file) throws Exception {
        return TemplateSerializer.loadTemplates(new FileInputStream(file));
    }

    public static TemplateSet loadTemplates(InputStream is) throws Exception {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            XMLReader parser = factory.newSAXParser().getXMLReader();
            ContentHandler handler = new ContentHandler();
            parser.setContentHandler(handler);
            parser.setErrorHandler(handler);
            parser.parse(new InputSource(is));
            TemplateSet templateSet = handler.getTemplates();
            return templateSet;
        }
        finally {
            Utils.close(is);
        }
    }

    public static void storeTemplates(TemplateSet templates, File file) throws Exception {
        FileWriter fw = null;
        try {
            fw = new FileWriter(file);
            DataWriter writer = new DataWriter((Writer)fw);
            writer.startDocument();
            writer.startElement(TEMPLATE_ROOT);
            TemplateSerializer.writeTemplates(writer, templates);
            writer.endElement(TEMPLATE_ROOT);
            writer.endDocument();
        }
        catch (Throwable throwable) {
            Utils.close(fw);
            throw throwable;
        }
        Utils.close(fw);
    }

    private static void writeTemplates(DataWriter writer, TemplateSet templates) throws Exception {
        List<TemplateEntry> list = templates.getTypeTemplates();
        int i = 0;
        while (i < list.size()) {
            TemplateSerializer.writeTemplateEntry(writer, list.get(i));
            ++i;
        }
        list = templates.getFieldTemplates();
        i = 0;
        while (i < list.size()) {
            TemplateSerializer.writeTemplateEntry(writer, list.get(i));
            ++i;
        }
        list = templates.getMethodTemplates();
        i = 0;
        while (i < list.size()) {
            TemplateSerializer.writeTemplateEntry(writer, list.get(i));
            ++i;
        }
        list = templates.getParameterTemplates();
        i = 0;
        while (i < list.size()) {
            TemplateSerializer.writeTemplateEntry(writer, list.get(i));
            ++i;
        }
        list = templates.getExceptionTemplates();
        i = 0;
        while (i < list.size()) {
            TemplateSerializer.writeTemplateEntry(writer, list.get(i));
            ++i;
        }
    }

    private static void writeTemplateEntry(DataWriter writer, TemplateEntry entry) throws Exception {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", TEMPLATE_KIND, "", "", Integer.toString(entry.getKind()));
        attributes.addAttribute("", TEMPLATE_NAME, "", "", entry.getName());
        attributes.addAttribute("", TEMPLATE_DEFAULT, "", "", Boolean.toString(entry.isDefaultTemplate()));
        attributes.addAttribute("", TEMPLATE_SIGNATURE, "", "", Boolean.toString(entry.isUseSignature()));
        writer.startElement("", TEMPLATE_ENTRY, "", (Attributes)attributes);
        writer.setIndentStep(writer.getIndentStep() + 2);
        writer.startElement(TEMPLATE_REGEX);
        writer.characters(entry.getRegex());
        writer.endElement(TEMPLATE_REGEX);
        writer.startElement(TEMPLATE_EXAMPLE);
        writer.characters(entry.getExample());
        writer.endElement(TEMPLATE_EXAMPLE);
        writer.startElement(TEMPLATE_TEXT);
        writer.characters(entry.getText());
        writer.endElement(TEMPLATE_TEXT);
        TemplateSerializer.writeTemplates(writer, entry.getChildTemplates());
        writer.setIndentStep(writer.getIndentStep() - 2);
        writer.endElement(TEMPLATE_ENTRY);
    }

    private static class ContentHandler
    extends DefaultHandler {
        private StringBuffer buffer;
        private TemplateSet templates;
        private TemplateEntry currentEntry;

        private ContentHandler() {
        }

        public TemplateSet getTemplates() {
            return this.templates;
        }

        @Override
        public void startDocument() throws SAXException {
            this.templates = new TemplateSet();
            this.currentEntry = null;
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (TemplateSerializer.TEMPLATE_ENTRY.equals(qName)) {
                this.currentEntry = new TemplateEntry(this.currentEntry);
                this.currentEntry.setKind(Integer.parseInt(attributes.getValue(TemplateSerializer.TEMPLATE_KIND)));
                this.currentEntry.setName(attributes.getValue(TemplateSerializer.TEMPLATE_NAME));
                this.currentEntry.setDefaultTemplate(Boolean.valueOf(attributes.getValue(TemplateSerializer.TEMPLATE_DEFAULT)));
                this.currentEntry.setUseSignature(Boolean.valueOf(attributes.getValue(TemplateSerializer.TEMPLATE_SIGNATURE)));
            }
            this.buffer = new StringBuffer();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.buffer != null) {
                this.buffer.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (TemplateSerializer.TEMPLATE_ENTRY.equals(qName)) {
                if (this.currentEntry.getParent() == null) {
                    this.templates.addTemplate(this.currentEntry);
                } else {
                    this.currentEntry.getParent().addChildTemplate(this.currentEntry);
                }
                this.currentEntry = this.currentEntry.getParent();
            } else if (TemplateSerializer.TEMPLATE_REGEX.equals(qName)) {
                this.currentEntry.setRegex(this.buffer.toString());
            } else if (TemplateSerializer.TEMPLATE_EXAMPLE.equals(qName)) {
                this.currentEntry.setExample(this.buffer.toString());
            } else if (TemplateSerializer.TEMPLATE_TEXT.equals(qName)) {
                this.currentEntry.setText(this.buffer.toString());
            }
            this.buffer = null;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            JAutodocPlugin.getDefault().handleException(e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            JAutodocPlugin.getDefault().handleException(e);
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            JAutodocPlugin.getDefault().handleException(e);
        }
    }
}

