/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.source;

import java.util.HashMap;
import java.util.Map;
import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.preferences.Configuration;
import net.sf.jautodoc.preferences.Constants;
import net.sf.jautodoc.source.AbstractSourceProcessor;
import net.sf.jautodoc.source.JavadocFormatter;
import net.sf.jautodoc.source.JavadocInfo;
import net.sf.jautodoc.source.SourceRange;
import net.sf.jautodoc.utils.LineDelimiterConverter;
import net.sf.jautodoc.utils.SourceUtils;
import net.sf.jautodoc.utils.TextEditHelper;
import net.sf.jautodoc.utils.Utils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class SourceManipulator
extends AbstractSourceProcessor {
    private String lineDelimiter;
    private MultiTextEdit textEdit;
    private Map<TextEdit, String> changeDescriptions;
    private int cursorPosition;
    private int cursorOffset;
    private boolean showPreview;
    private boolean forceAddHeader;

    public SourceManipulator(ICompilationUnit compUnit) {
        this(compUnit, null);
    }

    public SourceManipulator(ICompilationUnit compUnit, Configuration config) {
        super(compUnit, config);
    }

    public void addJavadoc(IProgressMonitor monitor) throws Exception {
        this.doProcessing(this.config, monitor);
    }

    public void addJavadoc(IMember[] members, IProgressMonitor monitor) throws Exception {
        this.doProcessing(members, monitor);
    }

    public void setCursorPosition(int cursorPosition) {
        this.cursorOffset = 0;
        this.cursorPosition = cursorPosition;
    }

    public int getCursorPosition() {
        return this.cursorPosition + this.cursorOffset;
    }

    public void setForceAddHeader(boolean forceAddHeader) {
        this.forceAddHeader = forceAddHeader;
    }

    public void setShowPreview(boolean showPreview) {
        this.showPreview = showPreview;
    }

    public MultiTextEdit getChanges() {
        return this.textEdit;
    }

    public Map<TextEdit, String> getChangeDescriptions() {
        return this.changeDescriptions;
    }

    @Override
    protected void startProcessing() {
        this.textEdit = new MultiTextEdit();
        this.changeDescriptions = new HashMap<TextEdit, String>();
        this.lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)this.document);
    }

    @Override
    protected void processFileHeader() throws Exception {
        this.addFileHeader();
    }

    @Override
    protected void processTodoForAutodoc(IMember[] members) throws Exception {
        if (this.config.isAddTodoForAutodoc() && members.length > 1) {
            this.addTodoForAutoDoc();
        }
    }

    @Override
    protected void processMember(IMember member) throws Exception {
        this.addJavadoc(member);
    }

    @Override
    protected void stopProcessing() throws Exception {
        if (!this.showPreview && this.applyTextEdits()) {
            this.compUnit.getBuffer().setContents(this.document.get());
            this.compUnit.reconcile(0, false, null, null);
        }
    }

    @Override
    protected String getTaskName() {
        return Constants.TITLE_JDOC_TASK;
    }

    private void addJavadoc(IMember member) throws Exception {
        ISourceRange docRange = SourceUtils.findJavadocSourceRange(member, this.commentScanner);
        JavadocInfo jdi = new JavadocInfo();
        String existingJavadoc = "";
        if (!(docRange.getLength() <= 0 || !this.config.isKeepExistingJavadoc() && !this.config.isCompleteExistingJavadoc() || this.config.isGetterSetterFromField() && this.config.isGetterSetterFromFieldReplace() && SourceUtils.isGetterSetter(member))) {
            existingJavadoc = this.document.get(docRange.getOffset(), docRange.getLength());
            jdi.parseJavadoc(existingJavadoc);
            if (this.config.isKeepExistingJavadoc() && !jdi.isEmpty()) {
                return;
            }
        }
        boolean inherited = false;
        String newJavadoc = "";
        String indent = SourceUtils.getIndentionString(this.document, member);
        if (member instanceof IType) {
            if (this.config.isCreateDummyComment()) {
                jdi = this.javadocCreator.applyTemplate(member, jdi);
            }
            newJavadoc = this.javadocCreator.createJavadoc((IType)member, indent, this.lineDelimiter, jdi);
        } else if (member instanceof IField) {
            if (this.config.isCreateDummyComment()) {
                jdi = this.javadocCreator.applyTemplate(member, jdi);
            }
            newJavadoc = this.javadocCreator.createJavadoc((IField)member, indent, this.lineDelimiter, jdi);
        } else if (member instanceof IMethod) {
            if (jdi.isEmpty()) {
                newJavadoc = SourceUtils.getInheritedJavadoc((IMethod)member, indent, this.lineDelimiter);
                inherited = newJavadoc != null && newJavadoc.length() > 0;
            } else if (jdi.isInheritDoc()) {
                return;
            }
            if (!inherited) {
                if (this.config.isGetterSetterFromField()) {
                    newJavadoc = this.javadocCreator.createMethodJavadocFromField((IMethod)member, indent, this.lineDelimiter, jdi, this.document, this.commentScanner);
                }
                if (newJavadoc == null || newJavadoc.length() == 0) {
                    if (this.config.isCreateDummyComment()) {
                        jdi = this.javadocCreator.applyTemplate(member, jdi);
                    }
                    newJavadoc = this.javadocCreator.createJavadoc((IMethod)member, indent, this.lineDelimiter, jdi);
                }
            }
        }
        if (SourceUtils.isSameComment(existingJavadoc, newJavadoc)) {
            return;
        }
        if (this.config.isUseEclipseFormatter() && !inherited) {
            newJavadoc = JavadocFormatter.getInstance().format(newJavadoc, indent, this.lineDelimiter);
        }
        if (Utils.needsLeadingEmptyLine(this.document, member, docRange)) {
            newJavadoc = String.valueOf(this.lineDelimiter) + indent + newJavadoc;
        }
        if (docRange.getLength() == 0) {
            newJavadoc = String.valueOf(newJavadoc) + this.lineDelimiter + indent;
        }
        if ((docRange.getLength() == 0 || !this.config.isKeepExistingJavadoc()) && Utils.needsReplacement(this.document, member, docRange, newJavadoc, inherited)) {
            this.doReplacement(docRange, newJavadoc, docRange.getLength() == 0 ? "Add Javadoc" : (this.config.isCompleteExistingJavadoc() ? "Complete existing Javadoc" : "Replace existing Javadoc"));
        }
    }

    private void addFileHeader() throws Exception {
        if (!this.config.isAddHeader() && !this.forceAddHeader) {
            return;
        }
        ISourceReference element = SourceUtils.getPackageOrImportReference(this.compUnit);
        if (element == null) {
            return;
        }
        ISourceRange range = element.getSourceRange();
        ISourceRange commentRange = SourceUtils.findCommentSourceRange(this.document, 0, range.getOffset() + range.getLength(), this.commentScanner, !this.config.isMultiCommentHeader());
        if (commentRange.getLength() > 0 && !this.config.isReplaceHeader()) {
            return;
        }
        String existingHeader = this.document.get(commentRange.getOffset(), commentRange.getLength());
        String newHeader = JAutodocPlugin.getContext().getTemplateManager().evaluateTemplate((IJavaElement)this.compUnit, this.config.getHeaderText(), "File Header", this.config.getProperties());
        newHeader = LineDelimiterConverter.convert(newHeader, this.lineDelimiter);
        if (existingHeader.length() == 0) {
            newHeader = String.valueOf(newHeader) + this.lineDelimiter;
        }
        if (!SourceUtils.isSameComment(existingHeader, newHeader)) {
            this.doReplacement(commentRange, newHeader, existingHeader.length() == 0 ? "Add file header" : "Replace existing file header");
        }
    }

    private void addTodoForAutoDoc() throws Exception {
        int length;
        IType type = SourceUtils.getFirstType(this.compUnit);
        if (type == null) {
            return;
        }
        ISourceRange range = type.getSourceRange();
        int start = range.getOffset();
        String source = this.document.get(start, length = range.getLength());
        if (!source.startsWith(Constants.TODO_FOR_AUTODOC)) {
            this.doReplacement(new SourceRange(start, 0), String.valueOf(Constants.TODO_FOR_AUTODOC) + this.lineDelimiter, "Add ToDo for auto-generated Javadoc");
        }
    }

    private void doReplacement(ISourceRange range, String replacement, String description) throws Exception {
        replacement = LineDelimiterConverter.convert(replacement, this.lineDelimiter);
        InsertEdit te = range.getLength() == 0 ? new InsertEdit(range.getOffset(), replacement) : new ReplaceEdit(range.getOffset(), range.getLength(), replacement);
        this.textEdit.addChild((TextEdit)te);
        this.changeDescriptions.put((TextEdit)te, description);
        if (this.cursorPosition >= range.getOffset()) {
            this.cursorOffset += replacement.length() - range.getLength();
        }
    }

    private boolean applyTextEdits() throws Exception {
        if (this.textEdit.hasChildren()) {
            new TextEditHelper(this.document, (TextEdit)this.textEdit).apply();
            return true;
        }
        return false;
    }
}

