/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.jautodoc.search.TaskSearchContentProvider;
import net.sf.jautodoc.search.TaskSearchResultPage;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.search.ui.text.AbstractTextSearchResult;

public class TaskSearchTreeContentProvider
extends TaskSearchContentProvider
implements ITreeContentProvider {
    public static final int LEVEL_TYPE = 1;
    public static final int LEVEL_FILE = 2;
    public static final int LEVEL_PACKAGE = 3;
    public static final int LEVEL_PROJECT = 4;
    private static final int[][] JAVA_ELEMENT_TYPES = new int[][]{{7}, {6, 5}, {4}, {2, 3}, {1}};
    private static final int[][] RESOURCE_TYPES = new int[][]{new int[0], {1}, {2}, {4}, {8}};
    private static final int MAX_LEVEL = JAVA_ELEMENT_TYPES.length - 1;
    private int currentLevel;
    private Map<Object, Set<Object>> childrenMap;
    private StandardJavaElementContentProvider contentProvider;

    public TaskSearchTreeContentProvider(TaskSearchResultPage resultPage, int level) {
        super(resultPage);
        this.currentLevel = level;
        this.contentProvider = new FastJavaElementProvider();
    }

    public Object getParent(Object child) {
        Object possibleParent;
        block7: {
            block6: {
                possibleParent = this.internalGetParent(child);
                if (!(possibleParent instanceof IJavaElement)) break block6;
                IJavaElement javaElement = (IJavaElement)possibleParent;
                int j = this.currentLevel;
                while (j < MAX_LEVEL + 1) {
                    int i = 0;
                    while (i < JAVA_ELEMENT_TYPES[j].length) {
                        if (javaElement.getElementType() == JAVA_ELEMENT_TYPES[j][i]) {
                            return null;
                        }
                        ++i;
                    }
                    ++j;
                }
                break block7;
            }
            if (!(possibleParent instanceof IResource)) break block7;
            IResource resource = (IResource)possibleParent;
            int j = this.currentLevel;
            while (j < MAX_LEVEL + 1) {
                int i = 0;
                while (i < RESOURCE_TYPES[j].length) {
                    if (resource.getType() == RESOURCE_TYPES[j][i]) {
                        return null;
                    }
                    ++i;
                }
                ++j;
            }
        }
        return possibleParent;
    }

    private Object internalGetParent(Object child) {
        return this.contentProvider.getParent(child);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    @Override
    protected synchronized void initialize(AbstractTextSearchResult result) {
        super.initialize(result);
        this.childrenMap = new HashMap<Object, Set<Object>>();
        if (result != null) {
            Object[] elements = result.getElements();
            int i = 0;
            while (i < elements.length) {
                if (this.getResultPage().getDisplayedFindingsCount(elements[i]) > 0) {
                    this.insert(null, null, elements[i]);
                }
                ++i;
            }
        }
    }

    protected void insert(Map<Object, Set<Object>> toAdd, Set<Object> toUpdate, Object child) {
        Object parent = this.getParent(child);
        while (parent != null) {
            if (this.insertChild(parent, child)) {
                if (toAdd != null) {
                    this.insertInto(parent, child, toAdd);
                }
            } else {
                if (toUpdate != null) {
                    toUpdate.add(parent);
                }
                return;
            }
            child = parent;
            parent = this.getParent(child);
        }
        if (this.insertChild(this.getSearchResult(), child)) {
            if (toAdd != null) {
                this.insertInto(this.getSearchResult(), child, toAdd);
            }
        } else if (toUpdate != null) {
            toUpdate.add(child);
        }
    }

    private boolean insertChild(Object parent, Object child) {
        return this.insertInto(parent, child, this.childrenMap);
    }

    private boolean insertInto(Object parent, Object child, Map<Object, Set<Object>> map) {
        Set<Object> children = map.get(parent);
        if (children == null) {
            children = new HashSet<Object>();
            map.put(parent, children);
        }
        return children.add(child);
    }

    protected void remove(Set<Object> toRemove, Set<Object> toUpdate, Object element) {
        if (this.hasChildren(element)) {
            if (toUpdate != null) {
                toUpdate.add(element);
            }
        } else if (this.getResultPage().getDisplayedFindingsCount(element) == 0) {
            this.childrenMap.remove(element);
            Object parent = this.getParent(element);
            if (parent != null) {
                if (this.removeFromSiblings(element, parent)) {
                    this.remove(toRemove, toUpdate, parent);
                }
            } else if (this.removeFromSiblings(element, this.getSearchResult()) && toRemove != null) {
                toRemove.add(element);
            }
        } else if (toUpdate != null) {
            toUpdate.add(element);
        }
    }

    private boolean removeFromSiblings(Object element, Object parent) {
        Set<Object> siblings = this.childrenMap.get(parent);
        if (siblings != null) {
            return siblings.remove(element);
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        Set<Object> children = this.childrenMap.get(parentElement);
        if (children == null) {
            return this.EMPTY_ARR;
        }
        int limit = this.getResultPage().getElementLimit();
        if (limit != -1 && limit < children.size()) {
            Object[] limitedArray = new Object[limit];
            Iterator<Object> iterator = children.iterator();
            int i = 0;
            while (i < limit) {
                limitedArray[i] = iterator.next();
                ++i;
            }
            return limitedArray;
        }
        return children.toArray();
    }

    public boolean hasChildren(Object element) {
        Set<Object> children = this.childrenMap.get(element);
        return children != null && !children.isEmpty();
    }

    @Override
    public synchronized void elementsChanged(Object[] updatedElements) {
        if (this.getSearchResult() == null) {
            return;
        }
        AbstractTreeViewer viewer = (AbstractTreeViewer)this.getResultPage().getViewer();
        HashSet<Object> toRemove = new HashSet<Object>();
        HashSet<Object> toUpdate = new HashSet<Object>();
        HashMap<Object, Set<Object>> toAdd = new HashMap<Object, Set<Object>>();
        int i = 0;
        while (i < updatedElements.length) {
            if (this.getResultPage().getDisplayedFindingsCount(updatedElements[i]) > 0) {
                this.insert(toAdd, toUpdate, updatedElements[i]);
            } else {
                this.remove(toRemove, toUpdate, updatedElements[i]);
            }
            ++i;
        }
        viewer.remove(toRemove.toArray());
        for (Object parent : toAdd.keySet()) {
            Set children = (Set)toAdd.get(parent);
            viewer.add(parent, children.toArray());
        }
        Iterator elementsToUpdate = toUpdate.iterator();
        while (elementsToUpdate.hasNext()) {
            viewer.refresh(elementsToUpdate.next());
        }
    }

    @Override
    public void clear() {
        this.initialize(this.getSearchResult());
        this.getResultPage().getViewer().refresh();
    }

    public void setLevel(int level) {
        this.currentLevel = level;
        this.initialize(this.getSearchResult());
        this.getResultPage().getViewer().refresh();
    }

    static class FastJavaElementProvider
    extends StandardJavaElementContentProvider {
        FastJavaElementProvider() {
        }

        public Object getParent(Object element) {
            return this.internalGetParent(element);
        }
    }
}

