/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.sf.jautodoc.search.TaskSearchMatch;
import net.sf.jautodoc.search.TaskSearchMatchFilter;
import net.sf.jautodoc.search.TaskSearchQuery;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FilterUpdateEvent;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchFilter;
import org.eclipse.ui.IEditorPart;

public class TaskSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private static final Match[] NO_MATCHES = new Match[0];
    private TaskSearchQuery searchQuery;

    public TaskSearchResult(TaskSearchQuery searchQuery) {
        this.searchQuery = searchQuery;
        this.setActiveMatchFilters(TaskSearchMatchFilter.getLastUsedFilters());
    }

    public MatchFilter[] getAllMatchFilters() {
        return TaskSearchMatchFilter.getAllFilters();
    }

    public void setActiveMatchFilters(MatchFilter[] filters) {
        TaskSearchMatchFilter.setLastUsedFilters(filters);
        this.updateFilterStateForAllMatches(this.getElements(), filters);
        super.setActiveMatchFilters(filters);
    }

    public void applyFilterState(Object[] elements) {
        this.updateFilterStateForAllMatches(this.getElements(), this.getActiveMatchFilters());
    }

    public TaskSearchMatch.Finding[] getFindings(Object element) {
        ArrayList<TaskSearchMatch.Finding> findings = new ArrayList<TaskSearchMatch.Finding>();
        Match[] matchArray = this.getMatches(element);
        int n = matchArray.length;
        int n2 = 0;
        while (n2 < n) {
            Match match = matchArray[n2];
            TaskSearchMatch taskSearchMatch = (TaskSearchMatch)match;
            findings.addAll(Arrays.asList(taskSearchMatch.getFindings()));
            ++n2;
        }
        return findings.toArray(new TaskSearchMatch.Finding[findings.size()]);
    }

    public TaskSearchMatch.Finding[] getFilteredFindings(Object element) {
        ArrayList<TaskSearchMatch.Finding> findings = new ArrayList<TaskSearchMatch.Finding>();
        Match[] matchArray = this.getMatches(element);
        int n = matchArray.length;
        int n2 = 0;
        while (n2 < n) {
            Match match = matchArray[n2];
            TaskSearchMatch taskSearchMatch = (TaskSearchMatch)match;
            TaskSearchMatch.Finding[] findingArray = taskSearchMatch.getFindings();
            int n3 = findingArray.length;
            int n4 = 0;
            while (n4 < n3) {
                TaskSearchMatch.Finding finding = findingArray[n4];
                if (!finding.isFiltered()) {
                    findings.add(finding);
                }
                ++n4;
            }
            ++n2;
        }
        return findings.toArray(new TaskSearchMatch.Finding[findings.size()]);
    }

    public int getFindingCount() {
        int count = 0;
        Object[] objectArray = this.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            count += this.getFindingCount(element);
            ++n2;
        }
        return count;
    }

    public int getFindingCount(Object element) {
        return this.getFindings(element).length;
    }

    public int getFilteredFindingCount() {
        int count = 0;
        Object[] objectArray = this.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            count += this.getFilteredFindingCount(element);
            ++n2;
        }
        return count;
    }

    public int getFilteredFindingCount(Object element) {
        return this.getFilteredFindings(element).length;
    }

    public ISearchQuery getQuery() {
        return this.searchQuery;
    }

    public String getLabel() {
        int findingCount = this.getFindingCount();
        int filteredOut = findingCount - this.getFilteredFindingCount();
        String postfix = findingCount == 1 ? "1 finding" : findingCount + " findings";
        postfix = String.valueOf(postfix) + " (" + filteredOut + " filtered from view)";
        return "'" + this.searchQuery.getSearchPattern().getDescription() + "' - " + postfix;
    }

    public String getTooltip() {
        return "JAutodoc Search";
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        return this.computeContainedMatches((IAdaptable)editor.getEditorInput());
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        Object element = match.getElement();
        if (element instanceof IJavaElement) {
            IOpenable openable = ((IJavaElement)element).getOpenable();
            return openable != null && openable.equals(editor.getEditorInput().getAdapter(IJavaElement.class));
        }
        if (element instanceof IFile) {
            return element.equals(editor.getEditorInput().getAdapter(IFile.class));
        }
        return false;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        return this.computeContainedMatches((IAdaptable)file);
    }

    public IFile getFile(Object element) {
        if (element instanceof IJavaElement) {
            IJavaElement javaElement = (IJavaElement)element;
            ICompilationUnit cu = (ICompilationUnit)javaElement.getAncestor(5);
            if (cu != null) {
                return (IFile)cu.getResource();
            }
            IClassFile cf = (IClassFile)javaElement.getAncestor(6);
            if (cf != null) {
                return (IFile)cf.getResource();
            }
            return null;
        }
        if (element instanceof IFile) {
            return (IFile)element;
        }
        return null;
    }

    private Match[] computeContainedMatches(IAdaptable adaptable) {
        IFile file;
        HashSet<Match> matches = new HashSet<Match>();
        IJavaElement javaElement = (IJavaElement)adaptable.getAdapter(IJavaElement.class);
        if (javaElement != null) {
            this.collectMatches(matches, javaElement);
        }
        if ((file = (IFile)adaptable.getAdapter(IFile.class)) != null) {
            this.collectMatches(matches, file);
        }
        if (!matches.isEmpty()) {
            return matches.toArray(new Match[matches.size()]);
        }
        return NO_MATCHES;
    }

    private void collectMatches(Set<Match> matches, IFile element) {
        Match[] m = this.getMatches(element);
        int i = 0;
        while (i < m.length) {
            matches.add(m[i]);
            ++i;
        }
    }

    private void collectMatches(Set<Match> matches, IJavaElement element) {
        Match[] m = this.getMatches(element);
        int i = 0;
        while (i < m.length) {
            matches.add(m[i]);
            ++i;
        }
        if (element instanceof IParent) {
            IParent parent = (IParent)element;
            try {
                IJavaElement[] children = parent.getChildren();
                int i2 = 0;
                while (i2 < children.length) {
                    this.collectMatches(matches, children[i2]);
                    ++i2;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    private void updateFilterStateForAllMatches(Object[] elements, MatchFilter[] matchFilters) {
        if (matchFilters == null) {
            matchFilters = TaskSearchMatchFilter.NO_FILTERS;
        }
        ArrayList<Match> changed = new ArrayList<Match>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            Match[] matchArray = this.getMatches(element);
            int n3 = matchArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Match match = matchArray[n4];
                if (this.updateFilterState((TaskSearchMatch)match, matchFilters)) {
                    changed.add(match);
                }
                ++n4;
            }
            ++n2;
        }
        Match[] allChanges = changed.toArray(new Match[changed.size()]);
        this.fireChange((SearchResultEvent)new FilterUpdateEvent((ISearchResult)this, allChanges, matchFilters));
    }

    private boolean updateFilterState(TaskSearchMatch match, MatchFilter[] matchFilters) {
        boolean findingFilterChanged = false;
        TaskSearchMatch.Finding[] findingArray = match.getFindings();
        int n = findingArray.length;
        int n2 = 0;
        while (n2 < n) {
            TaskSearchMatch.Finding finding = findingArray[n2];
            boolean wasFiltered = finding.isFiltered();
            finding.setFiltered(false);
            MatchFilter[] matchFilterArray = matchFilters;
            int n3 = matchFilters.length;
            int n4 = 0;
            while (n4 < n3) {
                MatchFilter matchFilter = matchFilterArray[n4];
                TaskSearchMatchFilter taskSearchMatchFilter = (TaskSearchMatchFilter)matchFilter;
                if (taskSearchMatchFilter.filters(finding)) {
                    finding.setFiltered(true);
                }
                ++n4;
            }
            if (finding.isFiltered() != wasFiltered) {
                findingFilterChanged = true;
            }
            ++n2;
        }
        return findingFilterChanged;
    }
}

