/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.search;

import net.sf.jautodoc.search.TaskSearchEngine;
import net.sf.jautodoc.search.TaskSearchPattern;
import net.sf.jautodoc.search.TaskSearchResult;
import net.sf.jautodoc.search.TaskSearchResultUpdater;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

public class TaskSearchQuery
implements ISearchQuery {
    private final ICompilationUnit[] compUnits;
    private final TaskSearchResult searchResult;
    private final TaskSearchPattern searchPattern;

    public TaskSearchQuery(ICompilationUnit[] compUnits, TaskSearchPattern searchPattern) {
        this.compUnits = compUnits;
        this.searchPattern = searchPattern;
        this.searchResult = new TaskSearchResult(this);
        new TaskSearchResultUpdater(compUnits, searchPattern, this.searchResult);
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.searchResult.removeAll();
        IStatus status = Status.OK_STATUS;
        try {
            this.doSearch(monitor);
        }
        catch (Exception e) {
            status = new Status(4, "net.sf.jautodoc", "Error in JAutodoc Search", (Throwable)e);
        }
        return status;
    }

    private void doSearch(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(this.getLabel(), this.compUnits.length * 5);
        ICompilationUnit[] iCompilationUnitArray = this.compUnits;
        int n = this.compUnits.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit cu = iCompilationUnitArray[n2];
            TaskSearchEngine engine = new TaskSearchEngine(cu, this.searchPattern, this.searchResult);
            engine.search((IProgressMonitor)new SubProgressMonitor(monitor, 5));
            if (monitor.isCanceled()) break;
            ++n2;
        }
    }

    public TaskSearchPattern getSearchPattern() {
        return this.searchPattern;
    }

    public String getLabel() {
        return "JAutodoc Search";
    }

    public ISearchResult getSearchResult() {
        return this.searchResult;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }
}

