/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.search;

import net.sf.jautodoc.search.TaskSearchLabelProvider;
import net.sf.jautodoc.search.TaskSearchResultPage;
import net.sf.jautodoc.search.TaskSearchTreeContentProvider;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledString;

public class TaskSearchPostfixLabelProvider
extends TaskSearchLabelProvider {
    private ITreeContentProvider contentProvider = new TaskSearchTreeContentProvider.FastJavaElementProvider();

    public TaskSearchPostfixLabelProvider(TaskSearchResultPage resultPage) {
        super(resultPage);
    }

    public String getText(Object element) {
        String labelWithCounts = this.getLabelWithCounts(element, this.internalGetText(element));
        return String.valueOf(labelWithCounts) + this.getQualification(element);
    }

    private String getQualification(Object element) {
        StringBuffer res = new StringBuffer();
        ITreeContentProvider provider = (ITreeContentProvider)this.resultPage.getViewer().getContentProvider();
        Object visibleParent = provider.getParent(element);
        Object realParent = this.contentProvider.getParent(element);
        Object lastElement = element;
        while (realParent != null && !(realParent instanceof IJavaModel) && !realParent.equals(visibleParent)) {
            if (!this.isSameInformation(realParent, lastElement)) {
                res.append(JavaElementLabels.CONCAT_STRING).append(this.internalGetText(realParent));
            }
            lastElement = realParent;
            realParent = this.contentProvider.getParent(realParent);
        }
        return res.toString();
    }

    @Override
    protected boolean hasChildren(Object element) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.resultPage.getViewer().getContentProvider();
        return contentProvider.hasChildren(element);
    }

    private String internalGetText(Object element) {
        return super.getText(element);
    }

    private StyledString internalGetStyledText(Object element) {
        return super.getStyledText(element);
    }

    private boolean isSameInformation(Object realParent, Object lastElement) {
        if (lastElement instanceof IType) {
            IType type = (IType)lastElement;
            if (realParent instanceof IClassFile ? type.getClassFile().equals(realParent) : realParent instanceof ICompilationUnit && type.getCompilationUnit().equals(realParent)) {
                return true;
            }
        }
        return false;
    }

    public StyledString getStyledText(Object element) {
        StyledString styledString = this.getColoredLabelWithCounts(element, this.internalGetStyledText(element));
        styledString.append(this.getQualification(element), StyledString.QUALIFIER_STYLER);
        return styledString;
    }
}

