/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.search;

import net.sf.jautodoc.search.TaskSearchResultPage;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.StyledString;

public abstract class TaskSearchLabelProvider
extends AppearanceAwareLabelProvider {
    public static final String PROPERTY_MATCH_COUNT = "net.sf.jautodoc.search.matchCount";
    protected static final long DEFAULT_SEARCH_TEXTFLAGS = 36421324767241L;
    protected static final int DEFAULT_SEARCH_IMAGEFLAGS = 1;
    protected TaskSearchResultPage resultPage;

    protected TaskSearchLabelProvider(TaskSearchResultPage resultPage) {
        super(36421324767241L, 1);
        this.resultPage = resultPage;
        this.addLabelDecorator((ILabelDecorator)new ProblemsLabelDecorator(null));
    }

    protected final StyledString getColoredLabelWithCounts(Object element, StyledString coloredName) {
        String name = coloredName.getString();
        String decorated = this.getLabelWithCounts(element, name);
        if (decorated.length() > name.length()) {
            this.styleDecoratedString(decorated, StyledString.COUNTER_STYLER, coloredName);
        }
        return coloredName;
    }

    protected final String getLabelWithCounts(Object element, String elementName) {
        int findingCount = this.resultPage.getDisplayedFindingsCount(element);
        if (findingCount < 2) {
            if (findingCount == 1 && this.hasChildren(element)) {
                return String.valueOf(elementName) + " (1 finding)";
            }
            return elementName;
        }
        return String.valueOf(elementName) + " (" + String.valueOf(findingCount) + " findings)";
    }

    protected boolean hasChildren(Object elem) {
        return false;
    }

    public boolean isLabelProperty(Object element, String property) {
        if (PROPERTY_MATCH_COUNT.equals(property)) {
            return true;
        }
        return super.isLabelProperty(element, property);
    }

    private StyledString styleDecoratedString(String decoratedString, StyledString.Styler decorationStyler, StyledString styledString) {
        String label = styledString.getString();
        int originalStart = decoratedString.indexOf(label);
        if (originalStart == -1) {
            return new StyledString(decoratedString);
        }
        if (decoratedString.length() == label.length()) {
            return styledString;
        }
        if (originalStart > 0) {
            StyledString newString = new StyledString(decoratedString.substring(0, originalStart), decorationStyler);
            newString.append(styledString);
            styledString = newString;
        }
        if (decoratedString.length() > originalStart + label.length()) {
            return styledString.append(decoratedString.substring(originalStart + label.length()), decorationStyler);
        }
        return styledString;
    }
}

