/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.search;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkingSet;

public class TaskSearchHelper {
    public static void collectCompilationUnitsOnWorkspace(Collection<ICompilationUnit> cus) throws JavaModelException {
        IJavaProject[] projects;
        IJavaProject[] iJavaProjectArray = projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject project = iJavaProjectArray[n2];
            TaskSearchHelper.collectCompilationUnits(project, cus);
            ++n2;
        }
    }

    public static void collectCompilationUnitsOnSelectedProjects(String[] projectNames, Collection<ICompilationUnit> cus) throws JavaModelException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < projectNames.length) {
            IJavaProject project = JavaCore.create((IProject)root.getProject(projectNames[i]));
            TaskSearchHelper.collectCompilationUnits(project, cus);
            ++i;
        }
    }

    public static void collectCompilationUnitsOnWorkingSets(IWorkingSet[] workingSets, Collection<ICompilationUnit> cus) throws JavaModelException {
        IWorkingSet[] iWorkingSetArray = workingSets;
        int n = workingSets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet workingSet = iWorkingSetArray[n2];
            TaskSearchHelper.collectCompilationUnits(workingSet, cus);
            ++n2;
        }
    }

    public static void collectCompilationUnitsOnSelection(IStructuredSelection selection, Collection<ICompilationUnit> cus) throws JavaModelException {
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            TaskSearchHelper.collectCompilationUnits(object, cus);
            ++n2;
        }
    }

    public static void collectCompilationUnits(IWorkingSet workingSet, Collection<ICompilationUnit> cus) throws JavaModelException {
        IAdaptable[] elements;
        IAdaptable[] iAdaptableArray = elements = workingSet.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable element = iAdaptableArray[n2];
            TaskSearchHelper.collectCompilationUnits(element, cus);
            ++n2;
        }
    }

    public static void collectCompilationUnits(IJavaProject project, Collection<ICompilationUnit> cus) throws JavaModelException {
        if (project.exists() && project.isOpen()) {
            IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
            int k = 0;
            while (k < roots.length) {
                TaskSearchHelper.collectCompilationUnits(roots[k], cus);
                ++k;
            }
        }
    }

    public static void collectCompilationUnits(IPackageFragmentRoot root, Collection<ICompilationUnit> cus) throws JavaModelException {
        if (root.getKind() == 1) {
            IJavaElement[] children = root.getChildren();
            int i = 0;
            while (i < children.length) {
                TaskSearchHelper.collectCompilationUnits((IPackageFragment)children[i], cus);
                ++i;
            }
        }
    }

    public static void collectCompilationUnits(IPackageFragment pkg, Collection<ICompilationUnit> cus) throws JavaModelException {
        cus.addAll(Arrays.asList(pkg.getCompilationUnits()));
    }

    public static void collectCompilationUnits(Object object, Collection<ICompilationUnit> cus) throws JavaModelException {
        IJavaElement javaElement;
        if (object instanceof IJavaElement && (javaElement = (IJavaElement)object).exists()) {
            switch (javaElement.getElementType()) {
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    cus.add(((IMember)javaElement).getCompilationUnit());
                    break;
                }
                case 5: {
                    cus.add((ICompilationUnit)javaElement);
                    break;
                }
                case 12: {
                    cus.add((ICompilationUnit)javaElement.getParent());
                    break;
                }
                case 4: {
                    TaskSearchHelper.collectCompilationUnits((IPackageFragment)javaElement, cus);
                    break;
                }
                case 3: {
                    TaskSearchHelper.collectCompilationUnits((IPackageFragmentRoot)javaElement, cus);
                    break;
                }
                case 2: {
                    TaskSearchHelper.collectCompilationUnits((IJavaProject)javaElement, cus);
                }
            }
        }
    }
}

