/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.search;

import java.util.Collections;
import net.sf.jautodoc.ResourceManager;
import net.sf.jautodoc.search.TaskSearchMatch;
import net.sf.jautodoc.search.TaskSearchResultPage;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;

public class TaskSearchDetailViewer
extends TableViewer {
    private static final String[] COLUMN_HEADERS = new String[]{"", "Finding"};
    private static final ColumnLayoutData[] COLUMN_LAYOUTS = new ColumnLayoutData[]{new ColumnPixelData(18, false, true), new ColumnWeightData(100)};
    private final TaskSearchResultPage searchResultPage;

    public TaskSearchDetailViewer(Composite parent, TaskSearchResultPage searchResultPage) {
        super(TaskSearchDetailViewer.createTable(parent));
        this.searchResultPage = searchResultPage;
        this.createColumns();
        this.createOpenAction();
        this.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new DetailLabelProvider());
        this.setComparator(new FindingComparator());
        this.setInput(Collections.EMPTY_LIST);
    }

    void clearViewer() {
        this.setInput("");
    }

    private static Table createTable(Composite parent) {
        return new Table(parent, 66306);
    }

    private void createColumns() {
        TableLayout layout = new TableLayout();
        this.getTable().setLayout((Layout)layout);
        this.getTable().setHeaderVisible(true);
        int i = 0;
        while (i < COLUMN_HEADERS.length) {
            layout.addColumnData(COLUMN_LAYOUTS[i]);
            TableColumn tc = new TableColumn(this.getTable(), 0, i);
            tc.setResizable(TaskSearchDetailViewer.COLUMN_LAYOUTS[i].resizable);
            tc.setText(COLUMN_HEADERS[i]);
            ++i;
        }
    }

    private void createOpenAction() {
        final OpenFindingAction openFindingAction = new OpenFindingAction();
        this.initContextMenu(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                menu.add((IContributionItem)new GroupMarker("group.show"));
                menu.appendToGroup("group.show", (IAction)openFindingAction);
            }
        });
        this.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (openFindingAction.isEnabled()) {
                    openFindingAction.run((IStructuredSelection)((StructuredSelection)TaskSearchDetailViewer.this.getSelection()));
                }
            }
        });
    }

    private void initContextMenu(IMenuListener menuListener) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(menuListener);
        Menu menu = menuMgr.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    private static class DetailLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final int COLUMN_ICON = 0;
        private static final int COLUMN_FINDING = 1;

        private DetailLabelProvider() {
        }

        public String getText(Object element) {
            return this.getColumnText(element, 1);
        }

        public Image getImage(Object element) {
            return this.getColumnImage(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ResourceManager.getImage("match_detail.gif");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0 || !(element instanceof TaskSearchMatch.Finding)) {
                return "";
            }
            return ((TaskSearchMatch.Finding)element).getMessage();
        }
    }

    private static class FindingComparator
    extends ViewerComparator {
        private FindingComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof TaskSearchMatch.Finding && e2 instanceof TaskSearchMatch.Finding) {
                TaskSearchMatch.Finding f1 = (TaskSearchMatch.Finding)e1;
                TaskSearchMatch.Finding f2 = (TaskSearchMatch.Finding)e2;
                int rc = f1.getMatch().getOffset() - f2.getMatch().getOffset();
                if (rc != 0) {
                    return rc;
                }
                rc = f1.getId().ordinal() - f2.getId().ordinal();
                if (rc != 0) {
                    return rc;
                }
                rc = f1.getMessage().length() - f2.getMessage().length();
                if (rc != 0) {
                    return rc;
                }
                return this.getComparator().compare(f1.getMessage(), f2.getMessage());
            }
            return this.getComparator().compare(e1.toString(), e2.toString());
        }
    }

    private class OpenFindingAction
    extends SelectionDispatchAction {
        public OpenFindingAction() {
            super((IWorkbenchSite)TaskSearchDetailViewer.this.searchResultPage.getSite());
            this.setText("Open");
            this.setToolTipText("Open Finding");
        }

        public boolean isEnabled() {
            return this.checkEnabled((IStructuredSelection)this.getSelection());
        }

        public ISelection getSelection() {
            return TaskSearchDetailViewer.this.getSelection();
        }

        public void run(IStructuredSelection selection) {
            if (this.checkEnabled(selection)) {
                TaskSearchMatch.Finding finding = (TaskSearchMatch.Finding)selection.getFirstElement();
                this.showMatch(finding.getMatch());
            }
        }

        private boolean checkEnabled(IStructuredSelection selection) {
            return selection.size() == 1 && selection.getFirstElement() instanceof TaskSearchMatch.Finding;
        }

        private void showMatch(final Match match) {
            ISafeRunnable runnable = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    if (exception instanceof PartInitException) {
                        PartInitException pie = (PartInitException)exception;
                        ErrorDialog.openError((Shell)OpenFindingAction.this.getSite().getShell(), (String)"Show Match", (String)"Could not find an editor for the current match", (IStatus)pie.getStatus());
                    }
                }

                public void run() throws Exception {
                    TaskSearchDetailViewer.this.searchResultPage.showMatch(match, match.getOffset(), match.getLength(), true);
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
    }
}

