/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.search;

import org.eclipse.jface.internal.text.InformationControlReplacer;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class MyInformationControlReplacer
extends InformationControlReplacer {
    private final ColumnViewer viewer;

    public MyInformationControlReplacer(ColumnViewer viewer) {
        super((IInformationControlCreator)new DefaultInformationControlCreator());
        this.viewer = viewer;
        this.setCloser(new Closer());
        this.install(viewer.getControl());
    }

    private class Closer
    implements AbstractInformationControlManager.IInformationControlCloser,
    ControlListener,
    MouseListener,
    KeyListener,
    FocusListener,
    Listener {
        private Control fSubjectControl;
        private boolean fIsActive = false;
        private Display fDisplay;

        private Closer() {
        }

        public void setSubjectControl(Control control) {
            this.fSubjectControl = control;
        }

        public void setInformationControl(IInformationControl control) {
        }

        public void start(Rectangle informationArea) {
            IInformationControl fInformationControlToClose;
            if (this.fIsActive) {
                return;
            }
            this.fIsActive = true;
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.addControlListener((ControlListener)this);
                this.fSubjectControl.addMouseListener((MouseListener)this);
                this.fSubjectControl.addKeyListener((KeyListener)this);
            }
            if ((fInformationControlToClose = MyInformationControlReplacer.this.getCurrentInformationControl2()) != null) {
                fInformationControlToClose.addFocusListener((FocusListener)this);
            }
            this.fDisplay = this.fSubjectControl.getDisplay();
            if (!this.fDisplay.isDisposed()) {
                this.fDisplay.addFilter(5, (Listener)this);
                this.fDisplay.addFilter(16, (Listener)this);
            }
        }

        public void stop() {
            IInformationControl fInformationControlToClose;
            if (!this.fIsActive) {
                return;
            }
            this.fIsActive = false;
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.removeControlListener((ControlListener)this);
                this.fSubjectControl.removeMouseListener((MouseListener)this);
                this.fSubjectControl.removeKeyListener((KeyListener)this);
            }
            if ((fInformationControlToClose = MyInformationControlReplacer.this.getCurrentInformationControl2()) != null) {
                fInformationControlToClose.removeFocusListener((FocusListener)this);
            }
            if (this.fDisplay != null && !this.fDisplay.isDisposed()) {
                this.fDisplay.removeFilter(5, (Listener)this);
                this.fDisplay.removeFilter(16, (Listener)this);
            }
            this.fDisplay = null;
        }

        public void controlResized(ControlEvent e) {
            MyInformationControlReplacer.this.hideInformationControl();
        }

        public void controlMoved(ControlEvent e) {
            MyInformationControlReplacer.this.hideInformationControl();
        }

        public void mouseDown(MouseEvent e) {
            MyInformationControlReplacer.this.hideInformationControl();
        }

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
            MyInformationControlReplacer.this.hideInformationControl();
        }

        public void keyPressed(KeyEvent e) {
            MyInformationControlReplacer.this.hideInformationControl();
        }

        public void keyReleased(KeyEvent e) {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            if (DEBUG) {
                System.out.println("StickyHoverManager.Closer.focusLost(): " + e);
            }
            Display d = this.fSubjectControl.getDisplay();
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MyInformationControlReplacer.this.hideInformationControl();
                }
            });
        }

        public void handleEvent(Event event) {
            if (event.type == 5) {
                if (!(event.widget instanceof Control) || event.widget.isDisposed()) {
                    return;
                }
                IInformationControl infoControl = MyInformationControlReplacer.this.getCurrentInformationControl2();
                if (infoControl != null && !infoControl.isFocusControl() && infoControl instanceof IInformationControlExtension3) {
                    IInformationControlExtension3 iControl3 = (IInformationControlExtension3)infoControl;
                    Rectangle controlBounds = iControl3.getBounds();
                    if (controlBounds != null) {
                        Point mouseLoc = event.display.map((Control)event.widget, null, event.x, event.y);
                        int margin = MyInformationControlReplacer.this.getKeepUpMargin();
                        Geometry.expand((Rectangle)controlBounds, (int)margin, (int)margin, (int)margin, (int)margin);
                        if (!controlBounds.contains(mouseLoc)) {
                            MyInformationControlReplacer.this.hideInformationControl();
                        }
                    }
                } else if (this.fDisplay != null && !this.fDisplay.isDisposed()) {
                    this.fDisplay.removeFilter(5, (Listener)this);
                }
            } else if (event.type == 16) {
                IInformationControl iControl;
                if (DEBUG) {
                    System.out.println("StickyHoverManager.Closer.handleEvent(): focusOut: " + event);
                }
                if ((iControl = MyInformationControlReplacer.this.getCurrentInformationControl2()) != null && !iControl.isFocusControl()) {
                    MyInformationControlReplacer.this.hideInformationControl();
                }
            }
        }
    }

    private static class DefaultInformationControlCreator
    extends AbstractReusableInformationControlCreator {
        private DefaultInformationControlCreator() {
        }

        public IInformationControl doCreateInformationControl(Shell shell) {
            return new DefaultInformationControl(shell, true);
        }
    }
}

