/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.preview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.MultiStateTextFileChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.ui.refactoring.LanguageElementNode;
import org.eclipse.ltk.ui.refactoring.TextEditChangeNode;
import org.eclipse.text.edits.TextEdit;

public class CompilationUnitChangeNode
extends TextEditChangeNode {
    static final TextEditChangeNode.ChildNode[] EMPTY_CHILDREN = new TextEditChangeNode.ChildNode[0];

    public CompilationUnitChangeNode(TextEditBasedChange change) {
        super(change);
    }

    protected TextEditChangeNode.ChildNode[] createChildNodes() {
        TextEditBasedChange change = this.getTextEditBasedChange();
        if (change instanceof MultiStateTextFileChange) {
            return EMPTY_CHILDREN;
        }
        ICompilationUnit compUnit = (ICompilationUnit)change.getAdapter(ICompilationUnit.class);
        if (compUnit != null) {
            ArrayList<TextEditChangeNode.ChildNode> children = new ArrayList<TextEditChangeNode.ChildNode>(5);
            HashMap<IJavaElement, JavaLanguageNode> map = new HashMap<IJavaElement, JavaLanguageNode>(20);
            TextEditBasedChangeGroup[] changes = this.getSortedChangeGroups(change);
            int i = 0;
            while (i < changes.length) {
                TextEditBasedChangeGroup tec = changes[i];
                try {
                    IJavaElement element = this.getModifiedJavaElement(tec, compUnit);
                    if (element.equals(compUnit)) {
                        children.add(CompilationUnitChangeNode.createTextEditGroupNode((TextEditChangeNode)this, (TextEditBasedChangeGroup)tec));
                    } else {
                        JavaLanguageNode pjce = this.getChangeElement(map, element, children, this);
                        pjce.addChild(CompilationUnitChangeNode.createTextEditGroupNode((TextEditChangeNode.ChildNode)pjce, (TextEditBasedChangeGroup)tec));
                    }
                }
                catch (JavaModelException javaModelException) {
                    children.add(CompilationUnitChangeNode.createTextEditGroupNode((TextEditChangeNode)this, (TextEditBasedChangeGroup)tec));
                }
                ++i;
            }
            return children.toArray(new TextEditChangeNode.ChildNode[children.size()]);
        }
        return EMPTY_CHILDREN;
    }

    private TextEditBasedChangeGroup[] getSortedChangeGroups(TextEditBasedChange change) {
        TextEditBasedChangeGroup[] edits = change.getChangeGroups();
        ArrayList<TextEditBasedChangeGroup> result = new ArrayList<TextEditBasedChangeGroup>(edits.length);
        int i = 0;
        while (i < edits.length) {
            if (!edits[i].getTextEditGroup().isEmpty()) {
                result.add(edits[i]);
            }
            ++i;
        }
        Collections.sort(result, new OffsetComparator());
        return result.toArray(new TextEditBasedChangeGroup[result.size()]);
    }

    private IJavaElement getModifiedJavaElement(TextEditBasedChangeGroup edit, ICompilationUnit compUnit) throws JavaModelException {
        IRegion range = edit.getRegion();
        if (range.getOffset() == 0 && range.getLength() == 0) {
            return compUnit;
        }
        IJavaElement result = compUnit.getElementAt(range.getOffset() + 1);
        if (result == null) {
            return compUnit;
        }
        try {
            while (true) {
                ISourceReference ref = (ISourceReference)result;
                Region sRange = new Region(ref.getSourceRange().getOffset(), ref.getSourceRange().getLength());
                if (result.getElementType() != 5 && result.getParent() != null && !this.coveredBy(edit, (IRegion)sRange)) {
                    result = result.getParent();
                    continue;
                }
                break;
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (ClassCastException classCastException) {}
        return result;
    }

    private JavaLanguageNode getChangeElement(Map<IJavaElement, JavaLanguageNode> map, IJavaElement element, List<TextEditChangeNode.ChildNode> children, TextEditChangeNode cunitChange) {
        JavaLanguageNode result = map.get(element);
        if (result != null) {
            return result;
        }
        IJavaElement parent = element.getParent();
        if (parent instanceof ICompilationUnit) {
            result = new JavaLanguageNode(cunitChange, element);
            children.add((TextEditChangeNode.ChildNode)result);
            map.put(element, result);
        } else {
            JavaLanguageNode parentChange = this.getChangeElement(map, parent, children, cunitChange);
            result = new JavaLanguageNode((TextEditChangeNode.ChildNode)parentChange, element);
            parentChange.addChild((TextEditChangeNode.ChildNode)result);
            map.put(element, result);
        }
        return result;
    }

    private boolean coveredBy(TextEditBasedChangeGroup group, IRegion sourceRegion) {
        int sLength = sourceRegion.getLength();
        if (sLength == 0) {
            return false;
        }
        int sOffset = sourceRegion.getOffset();
        int sEnd = sOffset + sLength - 1;
        TextEdit[] edits = group.getTextEdits();
        int i = 0;
        while (i < edits.length) {
            TextEdit edit = edits[i];
            if (edit.isDeleted()) {
                return false;
            }
            int rOffset = edit.getOffset();
            int rLength = edit.getLength();
            int rEnd = rOffset + rLength - 1;
            if (rLength == 0 ? sOffset > rOffset || rOffset > sEnd : sOffset > rOffset || rEnd > sEnd) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static class JavaLanguageNode
    extends LanguageElementNode {
        private static JavaElementImageProvider imageProvider = new JavaElementImageProvider();
        private final IJavaElement javaElement;

        public JavaLanguageNode(TextEditChangeNode parent, IJavaElement javaElement) {
            super(parent);
            this.javaElement = javaElement;
            Assert.isNotNull((Object)javaElement);
        }

        public JavaLanguageNode(TextEditChangeNode.ChildNode parent, IJavaElement javaElement) {
            super(parent);
            this.javaElement = javaElement;
            Assert.isNotNull((Object)javaElement);
        }

        public String getText() {
            return JavaElementLabels.getElementLabel((IJavaElement)this.javaElement, (long)JavaElementLabels.ALL_DEFAULT);
        }

        public ImageDescriptor getImageDescriptor() {
            return imageProvider.getJavaImageDescriptor(this.javaElement, 3);
        }

        public IRegion getTextRange() throws CoreException {
            ISourceRange range = ((ISourceReference)this.javaElement).getSourceRange();
            return new Region(range.getOffset(), range.getLength());
        }
    }

    private static class OffsetComparator
    implements Comparator<TextEditBasedChangeGroup> {
        private OffsetComparator() {
        }

        @Override
        public int compare(TextEditBasedChangeGroup g1, TextEditBasedChangeGroup g2) {
            int p2;
            int p1 = this.getOffset(g1);
            if (p1 < (p2 = this.getOffset(g2))) {
                return -1;
            }
            if (p1 > p2) {
                return 1;
            }
            return 0;
        }

        private int getOffset(TextEditBasedChangeGroup edit) {
            return edit.getRegion().getOffset();
        }
    }
}

