/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.preferences.replacements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.jautodoc.preferences.replacements.Replacement;

public class ReplacementManager {
    private final Map<String, Replacement> fieldReplacements = new HashMap<String, Replacement>();
    private final Map<String, Replacement> methodReplacements = new HashMap<String, Replacement>();

    public ReplacementManager(Replacement[] replacements) {
        this.init(replacements);
    }

    public ReplacementManager(ReplacementManager other) {
        this.fieldReplacements.putAll(other.fieldReplacements);
        this.methodReplacements.putAll(other.methodReplacements);
    }

    public String[] doReplacements(String[] strings, int scope) {
        Map<String, Replacement> replacements = this.getReplacements(scope);
        ArrayList<String> newStrings = new ArrayList<String>(strings.length);
        int i = 0;
        while (i < strings.length) {
            Replacement r = replacements.get(strings[i].toLowerCase());
            if (r != null && (i == 0 || r.getMode() == 1)) {
                if (r.getReplacement().length() > 0) {
                    newStrings.add(r.getReplacement());
                }
            } else {
                newStrings.add(strings[i]);
            }
            ++i;
        }
        return newStrings.toArray(new String[newStrings.size()]);
    }

    private Map<String, Replacement> getReplacements(int scope) {
        if (scope == 2) {
            return this.fieldReplacements;
        }
        return this.methodReplacements;
    }

    private void init(Replacement[] replacements) {
        int i = 0;
        while (i < replacements.length) {
            Replacement r = replacements[i];
            if (r.isFieldReplacement()) {
                this.fieldReplacements.put(r.getShortcut().toLowerCase(), r);
            }
            if (r.isMethodReplacement()) {
                this.methodReplacements.put(r.getShortcut().toLowerCase(), r);
            }
            ++i;
        }
    }
}

