/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.preferences.replacements;

import net.sf.jautodoc.preferences.Constants;
import net.sf.jautodoc.preferences.replacements.Replacement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ReplacementDialog
extends Dialog {
    private String title;
    private Label shortcutLabel;
    private Label replacementLabel;
    private Label scopeLabel;
    private Label modeLabel;
    private Text shortcutText;
    private Text replacementText;
    private Combo scopeCombo;
    private Combo modeCombo;
    private Replacement replacement;

    public ReplacementDialog(Shell shell, String title, Replacement initialValue) {
        super(shell);
        this.title = title;
        this.replacement = initialValue;
    }

    public Replacement getReplacement() {
        return this.replacement;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.horizontalSpacing = 10;
        comp.setLayout((Layout)layout);
        this.shortcutLabel = new Label(comp, 0);
        this.shortcutLabel.setText(Constants.LABEL_SHORTCUT);
        this.shortcutLabel.setFont(comp.getFont());
        this.shortcutText = new Text(comp, 2052);
        if (this.replacement != null) {
            this.shortcutText.setText(this.replacement.getShortcut());
        }
        GridData gd = new GridData(768);
        gd.widthHint = 250;
        gd.horizontalSpan = 3;
        this.shortcutText.setLayoutData((Object)gd);
        this.shortcutText.setFont(comp.getFont());
        this.shortcutText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ReplacementDialog.this.updateButtonStates();
            }
        });
        this.replacementLabel = new Label(comp, 0);
        this.replacementLabel.setText(Constants.LABEL_REPLACEMENT);
        this.replacementLabel.setFont(comp.getFont());
        this.replacementText = new Text(comp, 2052);
        if (this.replacement != null) {
            this.replacementText.setText(this.replacement.getReplacement());
        }
        gd = new GridData(768);
        gd.widthHint = 250;
        gd.horizontalSpan = 3;
        this.replacementText.setLayoutData((Object)gd);
        this.replacementText.setFont(comp.getFont());
        this.replacementText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ReplacementDialog.this.updateButtonStates();
            }
        });
        this.scopeLabel = new Label(comp, 0);
        this.scopeLabel.setText(Constants.LABEL_SCOPE);
        this.scopeLabel.setFont(comp.getFont());
        this.scopeCombo = new Combo(comp, 8);
        this.scopeCombo.setItems(new String[]{Constants.COLUMN_SCOPE_METHOD, Constants.COLUMN_SCOPE_FIELD, Constants.COLUMN_SCOPE_BOTH});
        if (this.replacement != null) {
            this.scopeCombo.select(this.replacement.getScope() - 1);
        } else {
            this.scopeCombo.select(0);
        }
        this.modeLabel = new Label(comp, 0);
        this.modeLabel.setText(Constants.LABEL_REPLACE_MODE);
        this.modeLabel.setFont(comp.getFont());
        this.modeCombo = new Combo(comp, 8);
        this.modeCombo.setItems(new String[]{Constants.COLUMN_MODE_PREFIX, Constants.COLUMN_MODE_ALL});
        if (this.replacement != null) {
            this.modeCombo.select(this.replacement.getMode());
        } else {
            this.modeCombo.select(0);
        }
        return comp;
    }

    protected void buttonPressed(int buttonId) {
        this.replacement = buttonId == 0 ? new Replacement(this.shortcutText.getText().trim(), this.replacementText.getText().trim(), this.scopeCombo.getSelectionIndex() + 1, this.modeCombo.getSelectionIndex()) : null;
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    public void create() {
        super.create();
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        this.getButton(0).setEnabled(this.shortcutText.getText().trim().length() > 0);
    }
}

