/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.preferences.replacements;

import java.io.File;
import java.text.MessageFormat;
import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.preferences.Constants;
import net.sf.jautodoc.preferences.TableContentProvider;
import net.sf.jautodoc.preferences.TableLabelProvider;
import net.sf.jautodoc.preferences.replacements.Replacement;
import net.sf.jautodoc.preferences.replacements.ReplacementDialog;
import net.sf.jautodoc.preferences.replacements.ReplacementSerializer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ReplacementBlock {
    private final String[] tableColumnHeaders = new String[]{Constants.COLUMN_SHORTCUT, Constants.COLUMN_REPLACEMENT, Constants.COLUMN_SCOPE, Constants.COLUMN_MODE};
    private final ColumnLayoutData[] tableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(24), new ColumnWeightData(42), new ColumnWeightData(17), new ColumnWeightData(17)};
    private TableViewer tableViewer;
    private Button editButton;
    private Button removeButton;
    private Button addButton;
    private Button importButton;
    private Button exportButton;

    public Replacement[] getReplacements() {
        Object[] obj = ((TableContentProvider)this.tableViewer.getContentProvider()).getElements(null);
        Replacement[] prs = new Replacement[obj.length];
        int i = 0;
        while (i < obj.length) {
            prs[i] = (Replacement)obj[i];
            ++i;
        }
        return prs;
    }

    public void setReplacements(Replacement[] replacements) {
        this.tableViewer.setInput((Object)replacements);
        this.updateButtonStates();
    }

    public Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        GridData gd = new GridData(32);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label.setFont(parent.getFont());
        label.setText(Constants.LABEL_TABLE);
        this.createTableViewer(composite);
        this.createButtonGroup(composite);
        return composite;
    }

    private void addReplacement() {
        ReplacementDialog dialog = new ReplacementDialog(this.tableViewer.getControl().getShell(), Constants.TITLE_ADD_REPLACEMENT, null);
        if (dialog.open() == 1) {
            return;
        }
        Replacement r = dialog.getReplacement();
        if (!this.checkOverwriteReplacement(r)) {
            return;
        }
        ((TableContentProvider)this.tableViewer.getContentProvider()).add(r);
    }

    private void editReplacement() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        Replacement oldPr = (Replacement)selection.getFirstElement();
        Replacement newPr = new Replacement(oldPr.getShortcut(), oldPr.getReplacement(), oldPr.getScope(), oldPr.getMode());
        ReplacementDialog dialog = new ReplacementDialog(this.tableViewer.getControl().getShell(), Constants.TITLE_EDIT_REPLACEMENT, newPr);
        if (dialog.open() == 1) {
            return;
        }
        newPr = dialog.getReplacement();
        if (!oldPr.equals(newPr) && !this.checkOverwriteReplacement(newPr)) {
            return;
        }
        oldPr.setShortcut(newPr.getShortcut());
        oldPr.setReplacement(newPr.getReplacement());
        oldPr.setScope(newPr.getScope());
        oldPr.setMode(newPr.getMode());
        this.tableViewer.refresh();
    }

    private void removeReplacement() {
        TableContentProvider contentProvider = (TableContentProvider)this.tableViewer.getContentProvider();
        IStructuredSelection sel = (IStructuredSelection)this.tableViewer.getSelection();
        contentProvider.remove(sel);
    }

    private boolean checkOverwriteReplacement(Replacement newReplacement) {
        Replacement[] replacements = this.getReplacements();
        int i = 0;
        while (i < replacements.length) {
            Replacement r = replacements[i];
            if (r.equals(newReplacement)) {
                boolean overWrite = MessageDialog.openQuestion((Shell)this.tableViewer.getControl().getShell(), (String)Constants.TITLE_OVERWRITE_REPLACEMENT, (String)MessageFormat.format(Constants.QUESTION_OVERWRITE_REPLACEMENT, r.getShortcut(), r.getScopeLabel()));
                if (!overWrite) {
                    return false;
                }
                ((TableContentProvider)this.tableViewer.getContentProvider()).remove(r);
                break;
            }
            ++i;
        }
        return true;
    }

    private void createTableViewer(Composite parent) {
        Table table = new Table(parent, 67586);
        GridData data = new GridData(1808);
        data.widthHint = 200;
        table.setLayoutData((Object)data);
        table.setFont(parent.getFont());
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ReplacementBlock.this.updateButtonStates();
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!event.getSelection().isEmpty() && ReplacementBlock.this.editButton.isEnabled()) {
                    ReplacementBlock.this.editReplacement();
                }
            }
        });
        this.tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.getSource() == ReplacementBlock.this.tableViewer && ReplacementBlock.this.removeButton.isEnabled() && event.character == '\u007f' && event.stateMask == 0) {
                    ReplacementBlock.this.removeReplacement();
                }
            }
        });
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        int i = 0;
        while (i < this.tableColumnHeaders.length) {
            tableLayout.addColumnData(this.tableColumnLayouts[i]);
            TableColumn column = new TableColumn(table, 0, i);
            column.setResizable(this.tableColumnLayouts[i].resizable);
            column.setText(this.tableColumnHeaders[i]);
            ++i;
        }
    }

    private void createButtonGroup(Composite parent) {
        Composite buttonGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonGroup.setLayout((Layout)layout);
        buttonGroup.setLayoutData((Object)new GridData(1296));
        buttonGroup.setFont(parent.getFont());
        this.importButton = this.createPushButton(buttonGroup, "Import...");
        this.exportButton = this.createPushButton(buttonGroup, "Export...");
        new Label(buttonGroup, 0);
        this.addButton = this.createPushButton(buttonGroup, Constants.BUTTON_ADD);
        this.editButton = this.createPushButton(buttonGroup, Constants.BUTTON_EDIT);
        this.removeButton = this.createPushButton(buttonGroup, Constants.BUTTON_REMOVE);
    }

    private Button createPushButton(Composite parent, String buttonText) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(buttonText);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.widget == ReplacementBlock.this.addButton) {
                    ReplacementBlock.this.addReplacement();
                } else if (event.widget == ReplacementBlock.this.editButton) {
                    ReplacementBlock.this.editReplacement();
                } else if (event.widget == ReplacementBlock.this.removeButton) {
                    ReplacementBlock.this.removeReplacement();
                } else if (event.widget == ReplacementBlock.this.importButton) {
                    ReplacementBlock.this.importReplacements();
                } else if (event.widget == ReplacementBlock.this.exportButton) {
                    ReplacementBlock.this.exportReplacements();
                }
            }
        });
        GridData gridData = new GridData(770);
        button.setLayoutData((Object)gridData);
        return button;
    }

    private void updateButtonStates() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        this.editButton.setEnabled(selection.size() == 1);
        this.removeButton.setEnabled(selection.size() > 0);
    }

    private void importReplacements() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        fileDialog.setText("Import");
        fileDialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
        String selectedFile = fileDialog.open();
        if (selectedFile == null) {
            return;
        }
        try {
            Replacement[] rs = ReplacementSerializer.deserialize(new File(selectedFile));
            this.setReplacements(rs);
        }
        catch (Exception e) {
            JAutodocPlugin.getDefault().handleException(this.getShell(), (Throwable)e);
        }
    }

    private void exportReplacements() {
        FileDialog fileDialog = new FileDialog(this.tableViewer.getControl().getShell(), 8192);
        fileDialog.setText("Export");
        fileDialog.setFileName("jautodoc_replacements.xml");
        fileDialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
        String selectedFile = fileDialog.open();
        if (selectedFile == null) {
            return;
        }
        File file = new File(selectedFile);
        if (file.exists() && !MessageDialog.openQuestion((Shell)this.getShell(), (String)"File exists", (String)("File '" + file.getName() + "' already exists. Replace?"))) {
            return;
        }
        try {
            ReplacementSerializer.serialize(this.getReplacements(), file);
        }
        catch (Exception e) {
            JAutodocPlugin.getDefault().handleException(this.getShell(), (Throwable)e);
        }
    }

    private Shell getShell() {
        return this.tableViewer.getControl().getShell();
    }
}

