/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import net.sf.jautodoc.preferences.Configuration;
import net.sf.jautodoc.preferences.ConfigurationManager;
import net.sf.jautodoc.preferences.OptionsBlock;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class OptionsDialog
extends Dialog {
    public static final int PREVIEW_ID = 1024;
    private Button globalSettingsButton;
    private Control optionPanel;
    private OptionsBlock ob;
    private ControlEnableState enableState;
    private String title;
    private Configuration config;
    private ICompilationUnit compUnit;

    public OptionsDialog(Shell parent, String title, ICompilationUnit compUnit) {
        super(parent);
        this.title = title;
        this.compUnit = compUnit;
        this.config = ConfigurationManager.getCachedConfiguration(compUnit);
        if (this.config == null) {
            this.config = ConfigurationManager.getConfiguration(compUnit, false);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite basePanel = new Composite(parent, 0);
        basePanel.setLayout((Layout)new GridLayout());
        Composite upperPanel = new Composite(basePanel, 0);
        upperPanel.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(768);
        upperPanel.setLayoutData((Object)gridData);
        this.globalSettingsButton = new Button(upperPanel, 32);
        this.globalSettingsButton.setText("Use project/workspace settings");
        this.globalSettingsButton.setLayoutData((Object)new GridData(768));
        this.globalSettingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OptionsDialog.this.updateControlStates();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                OptionsDialog.this.updateControlStates();
            }
        });
        Label horizontalLine = new Label(upperPanel, 258);
        horizontalLine.setLayoutData((Object)new GridData(768));
        this.ob = new OptionsBlock();
        this.optionPanel = this.ob.createContents(basePanel);
        this.updateControls();
        Dialog.applyDialogFont((Control)basePanel);
        return basePanel;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1024, "Preview", false);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (1024 == buttonId) {
            this.previewPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    private void updateControls() {
        this.ob.completeButton.setSelection(this.config.isCompleteExistingJavadoc());
        this.ob.keepButton.setSelection(this.config.isKeepExistingJavadoc());
        this.ob.replaceButton.setSelection(this.config.isReplaceExistingJavadoc());
        this.ob.publicButton.setSelection(this.config.isIncludePublic());
        this.ob.protectedButton.setSelection(this.config.isIncludeProtected());
        this.ob.packageButton.setSelection(this.config.isIncludePackage());
        this.ob.privateButton.setSelection(this.config.isIncludePrivate());
        this.ob.filterTypesButton.setSelection(this.config.isIncludeTypes());
        this.ob.filterFieldsButton.setSelection(this.config.isIncludeFields());
        this.ob.filterMethodsButton.setSelection(this.config.isIncludeMethods());
        this.ob.filterGetterSetterButton.setSelection(this.config.isGetterSetterOnly());
        this.ob.filterExcludeGetterSetterButton.setSelection(this.config.isExcludeGetterSetter());
        this.ob.todoButton.setSelection(this.config.isAddTodoForAutodoc());
        this.ob.dummyDocButton.setSelection(this.config.isCreateDummyComment());
        this.ob.singleLineButton.setSelection(this.config.isSingleLineComment());
        this.ob.useFormatterButton.setSelection(this.config.isUseEclipseFormatter());
        this.ob.getSetFromFieldButton.setSelection(this.config.isGetterSetterFromField());
        this.ob.getSetFromFieldFirstButton.setSelection(this.config.isGetterSetterFromFieldFirst());
        this.ob.getSetFromFieldReplaceButton.setSelection(this.config.isGetterSetterFromFieldReplace());
        this.ob.addHeaderButton.setSelection(this.config.isAddHeader());
        this.ob.replaceHeaderButton.setSelection(this.config.isReplaceHeader());
        this.ob.multiHeaderButton.setSelection(this.config.isMultiCommentHeader());
        this.ob.usePackageInfoButton.setSelection(this.config.isUsePackageInfo());
        this.ob.headerText = this.config.getHeaderText();
        this.ob.packageDocText = this.config.getPackageDocText();
        this.ob.packageInfoText = this.config.getPackageInfoText();
        this.ob.tagOrder = new ArrayList<String>(this.config.getTagOrder());
        this.ob.properties = new HashMap<String, String>(this.config.getProperties());
        this.ob.updateButtonStates();
        this.ob.editPackageDocButton.setEnabled(false);
        this.ob.usePackageInfoButton.setEnabled(false);
    }

    protected void previewPressed() {
        this.applyConfig();
        this.setReturnCode(1024);
        this.close();
    }

    protected void okPressed() {
        this.applyConfig();
        super.okPressed();
    }

    private void applyConfig() {
        if (this.globalSettingsButton.getSelection()) {
            ConfigurationManager.removeCachedConfiguration(this.compUnit);
        } else {
            this.config.setCompleteExistingJavadoc(this.ob.completeButton.getSelection());
            this.config.setKeepExistingJavadoc(this.ob.keepButton.getSelection());
            this.config.setReplaceExistingJavadoc(this.ob.replaceButton.getSelection());
            this.config.setVisibilityPublic(this.ob.publicButton.getSelection());
            this.config.setVisibilityProtected(this.ob.protectedButton.getSelection());
            this.config.setVisibilityPackage(this.ob.packageButton.getSelection());
            this.config.setVisibilityPrivate(this.ob.privateButton.getSelection());
            this.config.setCommentTypes(this.ob.filterTypesButton.getSelection());
            this.config.setCommentFields(this.ob.filterFieldsButton.getSelection());
            this.config.setCommentMethods(this.ob.filterMethodsButton.getSelection());
            this.config.setGetterSetterOnly(this.ob.filterGetterSetterButton.getSelection());
            this.config.setExcludeGetterSetter(this.ob.filterExcludeGetterSetterButton.getSelection());
            this.config.setAddTodoForAutodoc(this.ob.todoButton.getSelection());
            this.config.setCreateDummyComment(this.ob.dummyDocButton.getSelection());
            this.config.setSingleLineComment(this.ob.singleLineButton.getSelection());
            this.config.setUseEclipseFormatter(this.ob.useFormatterButton.getSelection());
            this.config.setGetterSetterFromField(this.ob.getSetFromFieldButton.getSelection());
            this.config.setIncludeSubPackages(this.ob.includeSubPackagesButton.getSelection());
            this.config.setGetterSetterFromFieldFirst(this.ob.getSetFromFieldFirstButton.getSelection());
            this.config.setGetterSetterFromFieldReplace(this.ob.getSetFromFieldReplaceButton.getSelection());
            this.config.setAddHeader(this.ob.addHeaderButton.getSelection());
            this.config.setReplaceHeader(this.ob.replaceHeaderButton.getSelection());
            this.config.setMultiCommentHeader(this.ob.multiHeaderButton.getSelection());
            this.config.setUsePackageInfo(this.ob.usePackageInfoButton.getSelection());
            this.config.setHeaderText(this.ob.headerText);
            this.config.setPackageDocText(this.ob.packageDocText);
            this.config.setPackageInfoText(this.ob.packageInfoText);
            this.config.setTagOrder(this.ob.tagOrder);
            this.config.setProperties(this.ob.properties);
            ConfigurationManager.cacheConfiguration(this.compUnit, this.config);
        }
    }

    private void updateControlStates() {
        if (!this.globalSettingsButton.getSelection()) {
            if (this.enableState != null) {
                this.enableState.restore();
                this.enableState = null;
            }
        } else if (this.enableState == null) {
            this.enableState = ControlEnableState.disable((Control)this.optionPanel);
        }
    }
}

