/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jautodoc.preferences;

import java.util.HashMap;
import java.util.Map;
import net.sf.jautodoc.JAutodocPlugin;
import net.sf.jautodoc.preferences.Configuration;
import net.sf.jautodoc.preferences.Constants;
import net.sf.jautodoc.preferences.PreferenceStore;
import net.sf.jautodoc.preferences.replacements.ReplacementManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.core.ICompilationUnit;

public class ConfigurationManager
implements Constants {
    private static Map<IProject, Configuration> configurations = new HashMap<IProject, Configuration>();
    private static Map<Object, Configuration> configurationCache = new HashMap<Object, Configuration>();
    private static Configuration currentConfiguration = null;
    private static Configuration workspaceConfiguration = null;

    static {
        currentConfiguration = workspaceConfiguration = new Configuration((PreferenceStore)JAutodocPlugin.getDefault().getPreferenceStore());
    }

    private ConfigurationManager() {
    }

    public static PreferenceStore getPreferenceStore() {
        return ConfigurationManager.getWorkspaceConfiguration().getPreferenceStore();
    }

    public static PreferenceStore getPreferenceStore(IProject project) {
        return ConfigurationManager.getConfiguration(project, true, false).getPreferenceStore();
    }

    public static Configuration getConfiguration(IProject project) {
        return ConfigurationManager.getConfiguration(project, true, true);
    }

    public static Configuration getConfiguration(IProject project, boolean readonly) {
        return ConfigurationManager.getConfiguration(project, readonly, true);
    }

    public static Configuration getConfiguration(IProject project, boolean readonly, boolean effective) {
        if (project == null) {
            return ConfigurationManager.checkReadonly(ConfigurationManager.getWorkspaceConfiguration(), readonly);
        }
        Configuration configuration = configurations.get(project);
        if (configuration == null) {
            PreferenceStore prefStore = new PreferenceStore((IScopeContext)new ProjectScope(project), JAutodocPlugin.getDefault().getBundle().getSymbolicName());
            currentConfiguration = configuration = new Configuration(prefStore, project);
            configurations.put(project, configuration);
        }
        if (!effective || configuration.getPreferenceStore().getBoolean("project_specific_settings")) {
            currentConfiguration = configuration;
            return ConfigurationManager.checkReadonly(configuration, readonly);
        }
        return ConfigurationManager.checkReadonly(ConfigurationManager.getWorkspaceConfiguration(), readonly);
    }

    public static Configuration getConfiguration(ICompilationUnit compUnit) {
        return ConfigurationManager.getConfiguration(compUnit, true);
    }

    public static Configuration getConfiguration(ICompilationUnit compUnit, boolean readonly) {
        return ConfigurationManager.getConfiguration(compUnit, readonly, true);
    }

    public static Configuration getConfiguration(ICompilationUnit compUnit, boolean readonly, boolean effective) {
        return ConfigurationManager.getConfiguration(compUnit.getJavaProject().getProject(), readonly, effective);
    }

    public static void cacheConfiguration(Object object, Configuration config) {
        configurationCache.put(object, config);
    }

    public static Configuration getCachedConfiguration(Object object) {
        Configuration configuration = configurationCache.get(object);
        if (configuration != null) {
            currentConfiguration = configuration;
        }
        return configuration;
    }

    public static boolean hasCachedConfiguration(Object object) {
        return configurationCache.containsKey(object);
    }

    public static void removeCachedConfiguration(Object object) {
        configurationCache.remove(object);
    }

    public static ReplacementManager getReplacementManager() {
        return ConfigurationManager.getCurrentConfiguration().getReplacementManager();
    }

    public static Configuration getCurrentConfiguration() {
        return currentConfiguration != null ? currentConfiguration : workspaceConfiguration;
    }

    private static Configuration getWorkspaceConfiguration() {
        currentConfiguration = workspaceConfiguration;
        return workspaceConfiguration;
    }

    private static Configuration checkReadonly(Configuration config, boolean readonly) {
        return readonly ? config : new Configuration(config);
    }
}

