/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.preferences;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusConfiguration;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusViewpoint;
import org.eclipse.papyrus.infra.viewpoints.iso42010.Iso42010Package;
import org.eclipse.papyrus.infra.viewpoints.iso42010.Stakeholder;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.WeightedConfiguration;
import org.eclipse.papyrus.infra.viewpoints.preferences.ResourceFieldEditor;
import org.eclipse.papyrus.infra.viewpoints.preferences.UpdatableComboBoxFieldEditor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ViewpointsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private PapyrusConfiguration currentConfig;
    private boolean customConfig;
    private String scheme;
    private RadioGroupFieldEditor fieldType;
    private ComboFieldEditor fieldScheme;
    private ResourceFieldEditor fieldPath;
    private BooleanFieldEditor fieldForceMultiplicity;
    private UpdatableComboBoxFieldEditor fieldStakeholder;
    private UpdatableComboBoxFieldEditor fieldViewpoint;
    private Label labelConfig;
    private Group groupCustom;
    private Group groupVP;

    public ViewpointsPreferencePage() {
        super(1);
        this.setPreferenceStore(PolicyChecker.getPreferences());
        this.setDescription("Preference page for the configuration of Papyrus viewpoints");
    }

    public void createFieldEditors() {
        IPreferenceStore store = this.getPreferenceStore();
        this.currentConfig = PolicyChecker.getCurrent().getConfiguration();
        String valueType = store.getString("papyrusViewpointsConfigurationType");
        this.scheme = store.getString("papyrusViewpointsUserDefinedScheme");
        if (this.scheme == null || this.scheme.isEmpty()) {
            this.scheme = "file";
        }
        this.fieldType = new RadioGroupFieldEditor("papyrusViewpointsConfigurationType", "Configuration selection:", 1, (String[][])new String[][]{{"Default (Papyrus built-in configuration, allows all)", "default"}, {"Deployed through the extension point", "extension"}, {"Manual configuration selection", "custom"}}, this.getFieldEditorParent(), true);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 4;
        Composite rest = new Composite(this.getFieldEditorParent(), 32);
        rest.setLayout((Layout)new FillLayout(512));
        rest.setLayoutData((Object)gd);
        this.groupCustom = new Group(rest, 16);
        this.groupCustom.setText("Manual configuration selection:");
        this.fieldScheme = new ComboFieldEditor("papyrusViewpointsUserDefinedScheme", "Access scheme:", (String[][])new String[][]{{"Absolute path", "file"}, {"Workspace file", "platform:/resource/"}, {"Embedded in a plugin", "platform:/plugin/"}}, (Composite)this.groupCustom);
        this.fieldScheme.setEnabled("custom".equals(valueType), (Composite)this.groupCustom);
        this.fieldPath = new ResourceFieldEditor("papyrusViewpointsUserDefinedConfiguration", "&Path:", (Composite)this.groupCustom);
        this.fieldPath.setMode(0);
        this.fieldPath.setEnabled("custom".equals(valueType), (Composite)this.groupCustom);
        if ("file".equals(this.scheme)) {
            this.fieldPath.setMode(0);
        } else if ("platform:/resource/".equals(this.scheme)) {
            this.fieldPath.setMode(1);
        } else if ("platform:/plugin/".equals(this.scheme)) {
            this.fieldPath.setMode(2);
        }
        this.groupVP = new Group(rest, 16);
        this.groupVP.setText("Viewpoint selection:");
        gd = new GridData();
        gd.horizontalSpan = 1;
        Label titleConf = new Label((Composite)this.groupVP, 16384);
        titleConf.setText("Configuration:");
        titleConf.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        this.labelConfig = new Label((Composite)this.groupVP, 16384);
        if ("default".equals(valueType)) {
            this.labelConfig.setText("Builtin");
        } else if ("extension".equals(valueType)) {
            WeightedConfiguration config = WeightedConfiguration.getTopConfiguration();
            this.labelConfig.setText(config == null ? "No suitable configuration" : config.getURI());
        } else if ("custom".equals(valueType)) {
            this.labelConfig.setText(store.getString("papyrusViewpointsUserDefinedConfiguration"));
        }
        this.labelConfig.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = 1;
        Label labelMulti = new Label((Composite)this.groupVP, 16384);
        labelMulti.setText("Multiplicity:");
        labelMulti.setLayoutData((Object)gd);
        this.fieldForceMultiplicity = new BooleanFieldEditor("papyrusViewpointsForceMultiplicity", "Force at most one view of each type per model element", (Composite)this.groupVP);
        this.fieldStakeholder = new UpdatableComboBoxFieldEditor("papyrusViewpointsSelectedStakeholder", "&Stakeholder:", (Composite)this.groupVP);
        this.fieldStakeholder.setContent((List<? extends EObject>)this.currentConfig.getStakeholders(), Iso42010Package.Literals.AD_ELEMENT__NAME);
        this.fieldViewpoint = new UpdatableComboBoxFieldEditor("papyrusViewpointsSelectedViewpoint", "&Viewpoint:", (Composite)this.groupVP);
        this.fieldViewpoint.setContent((List<? extends EObject>)PolicyChecker.getCurrent().getStakeholder().getViewpoints(), Iso42010Package.Literals.AD_ELEMENT__NAME);
        this.addField((FieldEditor)this.fieldType);
        this.addField((FieldEditor)this.fieldScheme);
        this.addField((FieldEditor)this.fieldPath);
        this.addField(this.fieldStakeholder);
        this.addField(this.fieldViewpoint);
    }

    protected void checkState() {
        super.checkState();
        if (this.currentConfig == null || this.fieldViewpoint.getSelection() == null || this.fieldStakeholder.getSelection() == null) {
            this.setMessage("The currently selected configuration does not provide adequate viewpoints", 3);
            this.setValid(false);
        } else {
            this.setMessage(null, 0);
            this.setValid(true);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.customConfig = false;
        WeightedConfiguration config = WeightedConfiguration.getTopConfiguration();
        this.currentConfig = config != null ? config.getConfiguration() : PolicyChecker.getDefaultConfiguration();
        this.fieldPath.setStringValue("");
        this.labelConfig.setText(config == null ? "Builtin default" : config.getURI());
        this.fieldPath.setEnabled(false, (Composite)this.groupCustom);
        this.fieldScheme.setEnabled(false, (Composite)this.groupCustom);
        if (this.currentConfig != null) {
            EList list = this.currentConfig.getStakeholders();
            this.fieldStakeholder.setContent((List<? extends EObject>)list, Iso42010Package.Literals.AD_ELEMENT__NAME);
            this.fieldViewpoint.setContent((List<? extends EObject>)((Stakeholder)list.get(0)).getViewpoints(), Iso42010Package.Literals.AD_ELEMENT__NAME);
        } else {
            this.fieldStakeholder.clearContent();
            this.fieldViewpoint.clearContent();
        }
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (!result) {
            return false;
        }
        if (this.currentConfig == null || this.fieldViewpoint.getSelection() == null || this.fieldStakeholder.getSelection() == null) {
            return false;
        }
        PolicyChecker newPolicy = new PolicyChecker(this.currentConfig, (PapyrusViewpoint)this.fieldViewpoint.getSelection(), this.fieldForceMultiplicity.getBooleanValue());
        PolicyChecker.setCurrent((PolicyChecker)newPolicy);
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() == this.fieldType) {
            this.onChangeType(event);
        } else if (event.getSource() == this.fieldScheme) {
            this.onChangeScheme(event);
        } else if (event.getSource() == this.fieldPath) {
            this.onChangePath(event);
        } else if (event.getSource() == this.fieldStakeholder) {
            this.onChangeStakeholder(event);
        }
        this.checkState();
    }

    private void onChangeType(PropertyChangeEvent event) {
        this.currentConfig = null;
        if ("default".equals(event.getNewValue())) {
            this.customConfig = false;
            this.currentConfig = PolicyChecker.getDefaultConfiguration();
            this.fieldPath.setStringValue("");
            this.labelConfig.setText("Builtin default");
        } else if ("extension".equals(event.getNewValue())) {
            this.customConfig = false;
            WeightedConfiguration config = WeightedConfiguration.getTopConfiguration();
            this.currentConfig = config != null ? config.getConfiguration() : PolicyChecker.getDefaultConfiguration();
            this.fieldPath.setStringValue("");
            this.labelConfig.setText(config == null ? "Builtin default" : config.getURI());
        } else if ("custom".equals(event.getNewValue())) {
            this.customConfig = true;
            this.labelConfig.setText("...");
        }
        this.fieldPath.setEnabled(this.customConfig, (Composite)this.groupCustom);
        this.fieldScheme.setEnabled(this.customConfig, (Composite)this.groupCustom);
        if (this.currentConfig != null) {
            EList list = this.currentConfig.getStakeholders();
            this.fieldStakeholder.setContent((List<? extends EObject>)list, Iso42010Package.Literals.AD_ELEMENT__NAME);
            this.fieldViewpoint.setContent((List<? extends EObject>)((Stakeholder)list.get(0)).getViewpoints(), Iso42010Package.Literals.AD_ELEMENT__NAME);
        } else {
            this.fieldStakeholder.clearContent();
            this.fieldViewpoint.clearContent();
        }
    }

    private void onChangeScheme(PropertyChangeEvent event) {
        this.scheme = event.getNewValue().toString();
        this.fieldPath.setStringValue("");
        if ("file".equals(this.scheme)) {
            this.fieldPath.setMode(0);
        } else if ("platform:/resource/".equals(this.scheme)) {
            this.fieldPath.setMode(1);
        } else if ("platform:/plugin/".equals(this.scheme)) {
            this.fieldPath.setMode(2);
        }
    }

    private void onChangePath(PropertyChangeEvent event) {
        if (!this.customConfig) {
            return;
        }
        String path = event.getNewValue().toString();
        this.currentConfig = null;
        if (path != null && !path.isEmpty()) {
            if ("file".equals(this.scheme)) {
                this.currentConfig = PolicyChecker.loadConfigurationFrom((String)path);
            } else if ("platform:/resource/".equals(this.scheme)) {
                this.currentConfig = PolicyChecker.loadConfigurationFrom((String)path);
            } else if ("platform:/plugin/".equals(this.scheme)) {
                this.currentConfig = PolicyChecker.loadConfigurationFrom((String)path);
            }
            this.labelConfig.setText(path);
        }
        if (this.currentConfig != null) {
            EList list = this.currentConfig.getStakeholders();
            this.fieldStakeholder.setContent((List<? extends EObject>)list, Iso42010Package.Literals.AD_ELEMENT__NAME);
            this.fieldViewpoint.setContent((List<? extends EObject>)((Stakeholder)list.get(0)).getViewpoints(), Iso42010Package.Literals.AD_ELEMENT__NAME);
        } else {
            this.fieldStakeholder.clearContent();
            this.fieldViewpoint.clearContent();
        }
    }

    private void onChangeStakeholder(PropertyChangeEvent event) {
        Object value = event.getNewValue();
        if (value != null) {
            Stakeholder stakeholder = (Stakeholder)value;
            this.fieldViewpoint.setContent((List<? extends EObject>)stakeholder.getViewpoints(), Iso42010Package.Literals.AD_ELEMENT__NAME);
        }
    }

    public void init(IWorkbench workbench) {
    }
}

