/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sashwindows.di.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.sashwindows.di.DiFactory;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashModel;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashWindowsMngr;
import org.eclipse.papyrus.infra.core.sashwindows.di.TabFolder;
import org.eclipse.papyrus.infra.core.sashwindows.di.Window;
import org.eclipse.papyrus.infra.core.sashwindows.di.exception.SashEditorException;

public class DiUtils {
    public static SashModel createDefaultSashModel() {
        SashModel sashModel = DiFactory.eINSTANCE.createSashModel();
        Window window = DiFactory.eINSTANCE.createWindow();
        sashModel.getWindows().add((Object)window);
        TabFolder folder = DiFactory.eINSTANCE.createTabFolder();
        window.setPanel(folder);
        sashModel.setCurrentSelectionSilently(folder);
        return sashModel;
    }

    public static SashWindowsMngr createDefaultSashWindowsMngr() {
        SashWindowsMngr model = DiFactory.eINSTANCE.createSashWindowsMngr();
        SashModel layout = DiUtils.createDefaultSashModel();
        model.setSashModel(layout);
        return model;
    }

    public static SashWindowsMngr lookupSashWindowsMngr(Resource diResource) {
        for (Object node : diResource.getContents()) {
            if (!(node instanceof SashWindowsMngr)) continue;
            return (SashWindowsMngr)node;
        }
        return null;
    }

    @Deprecated
    public static PageRef getPageRef(Resource diResource, EObject eObject) {
        SashWindowsMngr windowsMngr = DiUtils.lookupSashWindowsMngr(diResource);
        if (windowsMngr != null && windowsMngr.getPageList() != null) {
            for (PageRef pageRef : windowsMngr.getPageList().getAvailablePage()) {
                EObject emfPageIdentifier = pageRef.getEmfPageIdentifier();
                if (eObject == null || !eObject.equals(emfPageIdentifier)) continue;
                return pageRef;
            }
        }
        return null;
    }

    @Deprecated
    public static void addPageToPageList(Resource diResource, PageRef pageRef) throws SashEditorException {
    }

    @Deprecated
    public static void addPageToPageList(SashWindowsMngr windowsMngr, PageRef pageRef) throws SashEditorException {
    }

    @Deprecated
    public static void addPageToTabFolder(SashWindowsMngr windowsMngr, PageRef pageRef) throws SashEditorException {
        if (pageRef == null || pageRef.getPageIdentifier() == null) {
            throw new SashEditorException("Unable to add the page to the tab folder: parameters are null");
        }
        SashModel sashModel = windowsMngr.getSashModel();
        if (sashModel == null) {
            throw new SashEditorException("Unable to add the page to the tab folder: can't find SashModel");
        }
        TabFolder tabFolder = sashModel.getCurrentSelection();
        if (tabFolder == null) {
            throw new SashEditorException("Unable to add the page to the tab folder: No active folder");
        }
        tabFolder.addPage(pageRef.getPageIdentifier());
    }
}

