/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.gmfgraph;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Alignment implements Enumerator
{
    BEGINNING_LITERAL(0, "BEGINNING", "BEGINNING"),
    CENTER_LITERAL(1, "CENTER", "CENTER"),
    END_LITERAL(2, "END", "END"),
    FILL_LITERAL(3, "FILL", "FILL");

    public static final int BEGINNING = 0;
    public static final int CENTER = 1;
    public static final int END = 2;
    public static final int FILL = 3;
    private static final Alignment[] VALUES_ARRAY;
    public static final List<Alignment> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Alignment[]{BEGINNING_LITERAL, CENTER_LITERAL, END_LITERAL, FILL_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Alignment get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Alignment result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Alignment getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Alignment result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Alignment get(int value) {
        switch (value) {
            case 0: {
                return BEGINNING_LITERAL;
            }
            case 1: {
                return CENTER_LITERAL;
            }
            case 2: {
                return END_LITERAL;
            }
            case 3: {
                return FILL_LITERAL;
            }
        }
        return null;
    }

    private Alignment(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

