/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.specific.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.evm.api.Activation;
import org.eclipse.incquery.runtime.evm.api.RuleInstance;
import org.eclipse.incquery.runtime.evm.api.event.ActivationState;
import org.eclipse.incquery.runtime.evm.api.event.Event;
import org.eclipse.incquery.runtime.evm.api.event.EventFilter;
import org.eclipse.incquery.runtime.evm.api.event.EventType;
import org.eclipse.incquery.runtime.evm.api.event.adapter.EventHandlerAdapter;
import org.eclipse.incquery.runtime.evm.api.event.adapter.EventProcessorAdapter;
import org.eclipse.incquery.runtime.evm.notification.AttributeMonitor;
import org.eclipse.incquery.runtime.evm.notification.IActivationNotificationListener;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryActivationStateEnum;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventSource;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventTypeEnum;
import org.eclipse.incquery.runtime.evm.specific.event.LightweightAttributeMonitor;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;

public class IncQueryEventHandler<Match extends IPatternMatch>
extends EventHandlerAdapter<Match> {
    private AttributeMonitor<Match> attributeMonitor;
    private UnregisterMonitorActivationNotificationListener unregisterListener;

    protected IncQueryEventHandler(IncQueryEventSource<Match> source, EventFilter<? super Match> filter, RuleInstance<Match> instance) {
        super(source, filter, instance);
    }

    protected AttributeMonitor<Match> prepareAttributeMonitor() {
        LightweightAttributeMonitor monitor = null;
        IncQueryEventSource eventSource = (IncQueryEventSource)this.getSource();
        try {
            monitor = new LightweightAttributeMonitor(eventSource.getMatcher().getEngine().getBaseIndex());
        }
        catch (IncQueryException e) {
            IncQueryLoggingUtil.getLogger(this.getClass()).error((Object)"Error happened while accessing base index", (Throwable)e);
        }
        return monitor;
    }

    @Override
    protected void prepareEventHandler() {
        super.prepareEventHandler();
        this.attributeMonitor = (AttributeMonitor)Preconditions.checkNotNull(this.prepareAttributeMonitor(), (Object)"Prepared attribute monitor is null!");
        IncQueryEventSource eventSource = (IncQueryEventSource)this.getSource();
        eventSource.addHandler(this);
        this.attributeMonitor.addAttributeMonitorListener(eventSource.getAttributeMonitorListener());
        this.unregisterListener = (UnregisterMonitorActivationNotificationListener)Preconditions.checkNotNull((Object)this.prepareActivationNotificationListener(), (Object)"Prepared activation notification listener is null!");
        this.getInstance().addActivationNotificationListener(this.unregisterListener, false);
    }

    protected UnregisterMonitorActivationNotificationListener prepareActivationNotificationListener() {
        return new UnregisterMonitorActivationNotificationListener();
    }

    @Override
    protected Map<EventType, EventProcessorAdapter<Match>> prepareEventProcessors() {
        HashMap processors = Maps.newHashMap();
        processors.put(IncQueryEventTypeEnum.MATCH_APPEARS, new EventProcessorAdapter<Match>(this.getInstance()){

            @Override
            protected void activationExists(Event<Match> event, Activation<Match> activation) {
                this.getInstance().activationStateTransition(activation, IncQueryEventTypeEnum.MATCH_APPEARS);
            }

            @Override
            protected void activationMissing(Event<Match> event) {
                IPatternMatch eventAtom = (IPatternMatch)event.getEventAtom();
                Activation<IPatternMatch> activation = this.getInstance().createActivation(eventAtom);
                if (this.getInstance().getLifeCycle().containsTo(IncQueryActivationStateEnum.UPDATED)) {
                    IncQueryEventHandler.this.attributeMonitor.registerFor(eventAtom);
                }
                this.getInstance().activationStateTransition(activation, IncQueryEventTypeEnum.MATCH_APPEARS);
            }
        });
        processors.put(IncQueryEventTypeEnum.MATCH_UPDATES, new EventProcessorAdapter<Match>(this.getInstance()){

            @Override
            protected void activationExists(Event<Match> event, Activation<Match> activation) {
                this.getInstance().activationStateTransition(activation, IncQueryEventTypeEnum.MATCH_UPDATES);
            }

            @Override
            protected void activationMissing(Event<Match> event) {
                Preconditions.checkState((boolean)false, (Object)String.format("Atom %s updated without existing activation in rule instance %s!", event.getEventAtom(), this));
            }
        });
        processors.put(IncQueryEventTypeEnum.MATCH_DISAPPEARS, new EventProcessorAdapter<Match>(this.getInstance()){

            @Override
            protected void activationExists(Event<Match> event, Activation<Match> activation) {
                this.getInstance().activationStateTransition(activation, IncQueryEventTypeEnum.MATCH_DISAPPEARS);
            }

            @Override
            protected void activationMissing(Event<Match> event) {
                Preconditions.checkState((boolean)false, (Object)String.format("Match %s disappeared without existing activation in rule instance %s!", event.getEventAtom(), this));
            }
        });
        return processors;
    }

    @Override
    public void dispose() {
        this.getInstance().removeActivationNotificationListener(this.unregisterListener);
        ((IncQueryEventSource)this.getSource()).removeHandler(this);
        this.attributeMonitor.dispose();
    }

    private final class UnregisterMonitorActivationNotificationListener
    implements IActivationNotificationListener {
        private UnregisterMonitorActivationNotificationListener() {
        }

        @Override
        public void activationRemoved(Activation<?> activation, ActivationState oldState) {
            IncQueryEventHandler.this.attributeMonitor.unregisterFor((IPatternMatch)activation.getAtom());
        }

        @Override
        public void activationCreated(Activation<?> activation, ActivationState inactiveState) {
        }

        @Override
        public void activationChanged(Activation<?> activation, ActivationState oldState, EventType event) {
        }
    }
}

