/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.model.sgraph.validation;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.yakindu.sct.model.sgraph.Choice;
import org.yakindu.sct.model.sgraph.CompositeElement;
import org.yakindu.sct.model.sgraph.Entry;
import org.yakindu.sct.model.sgraph.EntryKind;
import org.yakindu.sct.model.sgraph.Exit;
import org.yakindu.sct.model.sgraph.FinalState;
import org.yakindu.sct.model.sgraph.Region;
import org.yakindu.sct.model.sgraph.State;
import org.yakindu.sct.model.sgraph.Statechart;
import org.yakindu.sct.model.sgraph.Synchronization;
import org.yakindu.sct.model.sgraph.Transition;
import org.yakindu.sct.model.sgraph.Vertex;
import org.yakindu.sct.model.sgraph.validation.DFS;

public class SGraphJavaValidator
extends AbstractDeclarativeValidator {
    public static final String ISSUE_STATE_WITHOUT_NAME = "A state must have a name.";
    public static final String ISSUE_NODE_NOT_REACHABLE = "Node is not reachable.";
    public static final String ISSUE_FINAL_STATE_OUTGOING_TRANSITION = "A final state should have no outgoing transition.";
    public static final String ISSUE_STATE_WITHOUT_OUTGOING_TRANSITION = "A state should have at least one outgoing transition.";
    public static final String ISSUE_INITIAL_ENTRY_WITH_IN_TRANS = "Initial entry should have no incoming transition.";
    public static final String ISSUE_INITIAL_ENTRY_WITHOUT_OUT_TRANS = "Initial entry should have a single outgoing transition";
    public static final String ISSUE_ENTRY_WITH_MULTIPLE_OUT_TRANS = "Entries must not have more than one outgoing transition";
    public static final String ISSUE_ENTRY_WITH_TRIGGER = "Outgoing Transitions from Entries can not have a Trigger or Guard.";
    public static final String ISSUE_EXIT_WITH_OUT_TRANS = "Exit node should have no outgoing transition.";
    public static final String ISSUE_EXIT_WITHOUT_IN_TRANS = "Exit node should have at least one incoming transition";
    public static final String ISSUE_EXIT_ON_STATECHART = "Exit node in top level region not supported - use final states instead.";
    public static final String ISSUE_CHOICE_WITHOUT_OUTGOING_TRANSITION = "A choice must have at least one outgoing transition.";
    public static final String ISSUE_REGION_CANT_BE_ENTERED_USING_SHALLOW_HISTORY_NO_DEFAULT_ENTRY = "The region can't be entered using the shallow history. Add a default entry node.";
    public static final String ISSUE_REGION_CANT_BE_ENTERED_USING_SHALLOW_HISTORY_NON_CONNECTED_DEFAULT_ENTRY = "The region can't be entered using the shallow history. Add a transition from default entry to a state.";
    public static final String ISSUE_SUBMACHINE_UNRESOLVABLE = "Referenced Substatemachine '%s'does not exist!";
    public static final String ISSUE_SYNCHRONIZATION_TARGET_STATES_NOT_ORTHOGONAL = "The target states of a synchronization must be orthogonal!";
    public static final String ISSUE_SYNCHRONIZATION_TARGET_STATES_NOT_WITHIN_SAME_PARENTSTATE = "The target states of a synchronization have to be contained in the same parent state within different regions!";
    public static final String ISSUE_SYNCHRONIZATION_SOURCE_STATES_NOT_ORTHOGONAL = "The source states of a synchronization must be orthogonal!";
    public static final String ISSUE_SYNCHRONIZATION_SOURCE_STATES_NOT_WITHIN_SAME_PARENTSTATE = "The source states of a synchronization have to be contained in the same parent state within different regions!";
    public static final String ISSUE_SYNCHRONIZATION_TRANSITION_COUNT = "A synchronization should have at least two incoming or two outgoing transitions";
    public static final String ISSUE_INITIAL_ENTRY_WITH_TRANSITION_TO_CONTAINER = "Outgoing Transitions from Entries can only target to sibling or inner states.";

    @Check(value=CheckType.FAST)
    public void vertexNotReachable(Vertex vertex) {
        if (!(vertex instanceof Entry)) {
            final HashSet<Object> stateScopeSet = new HashSet<Object>();
            for (EObject obj : EcoreUtil2.eAllContents((EObject)vertex)) {
                stateScopeSet.add(obj);
            }
            stateScopeSet.add(vertex);
            final ArrayList externalPredecessors = new ArrayList();
            DFS dfs = new DFS(){

                @Override
                public Iterator<Object> getElementLinks(Object element) {
                    ArrayList<Object> elements = new ArrayList<Object>();
                    if (element instanceof State) {
                        if (!stateScopeSet.contains(element)) {
                            externalPredecessors.add(element);
                        } else {
                            elements.addAll((Collection<Object>)((State)element).getRegions());
                            elements.addAll((Collection<Object>)((State)element).getIncomingTransitions());
                        }
                    } else if (element instanceof Region) {
                        elements.addAll((Collection<Object>)((Region)element).getVertices());
                    } else if (element instanceof Entry) {
                        if (!stateScopeSet.contains(element)) {
                            externalPredecessors.add(element);
                        } else {
                            elements.addAll((Collection<Object>)((Entry)element).getIncomingTransitions());
                        }
                    } else if (element instanceof Vertex) {
                        elements.addAll((Collection<Object>)((Vertex)element).getIncomingTransitions());
                    } else if (element instanceof Transition) {
                        elements.add(((Transition)element).getSource());
                    }
                    return elements.iterator();
                }
            };
            dfs.perform(vertex);
            if (externalPredecessors.size() == 0) {
                this.error(ISSUE_NODE_NOT_REACHABLE, (EObject)vertex, null, -1);
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void finalStateWithOutgoingTransition(FinalState finalState) {
        if (finalState.getOutgoingTransitions().size() > 0) {
            this.warning(ISSUE_FINAL_STATE_OUTGOING_TRANSITION, (EObject)finalState, null, -1);
        }
    }

    @Check(value=CheckType.FAST)
    public void nameIsNotEmpty(State state) {
        if (!(state.getName() != null && state.getName().trim().length() != 0 || state instanceof FinalState)) {
            this.error(ISSUE_STATE_WITHOUT_NAME, state, null, -1);
        }
    }

    @Check(value=CheckType.FAST)
    public void choiceWithoutOutgoingTransition(Choice choice) {
        if (choice.getOutgoingTransitions().size() == 0) {
            this.error(ISSUE_CHOICE_WITHOUT_OUTGOING_TRANSITION, (EObject)choice, null, -1);
        }
    }

    @Check(value=CheckType.FAST)
    public void disallowTrigger(Entry entry) {
        for (Transition transition : entry.getOutgoingTransitions()) {
            if (transition.getTrigger() == null) continue;
            this.error(ISSUE_ENTRY_WITH_TRIGGER, (EObject)entry, null, -1);
        }
    }

    @Check(value=CheckType.FAST)
    public void initialEntryWithoutIncomingTransitions(Entry entry) {
        if (entry.getIncomingTransitions().size() > 0 && entry.getKind().equals((Object)EntryKind.INITIAL)) {
            this.warning(ISSUE_INITIAL_ENTRY_WITH_IN_TRANS, (EObject)entry, null, -1);
        }
    }

    @Check(value=CheckType.FAST)
    public void initialEntryWithoutOutgoingTransition(Entry entry) {
        if (entry.getOutgoingTransitions().size() == 0 && entry.getKind().equals((Object)EntryKind.INITIAL)) {
            this.warning(ISSUE_INITIAL_ENTRY_WITHOUT_OUT_TRANS, (EObject)entry, null, -1);
        }
    }

    @Check(value=CheckType.FAST)
    public void initialEntryWithMultipleOutgoingTransition(Entry entry) {
        if (entry.getOutgoingTransitions().size() > 1) {
            this.error(ISSUE_ENTRY_WITH_MULTIPLE_OUT_TRANS, (EObject)entry, null, -1);
        }
    }

    @Check(value=CheckType.FAST)
    public void exitWithoutIncomingTransition(Exit exit) {
        if (exit.getIncomingTransitions().size() == 0) {
            this.warning(ISSUE_EXIT_WITHOUT_IN_TRANS, (EObject)exit, null, -1);
        }
    }

    @Check(value=CheckType.FAST)
    public void exitWithOutgoingTransition(Exit exit) {
        if (exit.getOutgoingTransitions().size() > 0) {
            this.error(ISSUE_EXIT_WITH_OUT_TRANS, (EObject)exit, null, -1);
        }
    }

    @Check(value=CheckType.FAST)
    public void exitOnStatechart(Exit exit) {
        if (exit.getParentRegion().getComposite() instanceof Statechart) {
            this.error(ISSUE_EXIT_ON_STATECHART, (EObject)exit, null, -1);
        }
    }

    @Check(value=CheckType.FAST)
    public void synchronizationTransitionCount(Synchronization sync) {
        if (sync.getIncomingTransitions().size() < 2 && sync.getOutgoingTransitions().size() < 2) {
            this.warning(ISSUE_SYNCHRONIZATION_TRANSITION_COUNT, (EObject)sync, null, -1);
        }
    }

    @Check(value=CheckType.FAST)
    public void initialEntryWithTransitionToContainer(Transition t) {
        if (t.getSource() instanceof Entry && !this.isChildOrSibling(t.getSource(), t.getTarget())) {
            this.error(ISSUE_INITIAL_ENTRY_WITH_TRANSITION_TO_CONTAINER, t, null, -1);
        }
    }

    private boolean isChildOrSibling(Vertex source, Vertex target) {
        TreeIterator iter = source.getParentRegion().eAllContents();
        while (iter.hasNext()) {
            if (target != iter.next()) continue;
            return true;
        }
        return false;
    }

    @Check(value=CheckType.FAST)
    public void regionCantBeEnteredUsingShallowHistory(Entry e) {
        if (e.getKind() == EntryKind.SHALLOW_HISTORY) {
            ArrayList regions = new ArrayList();
            for (Vertex v : e.getParentRegion().getVertices()) {
                if (!(v instanceof State)) continue;
                State state = (State)v;
                regions.addAll(state.getRegions());
            }
            for (Region r : regions) {
                Vertex defaultEntry = null;
                for (Vertex v : r.getVertices()) {
                    String name;
                    if (!(v instanceof Entry) || (name = v.getName().trim().toLowerCase()) == null && !"".equals(name) && !"default".equals(name)) continue;
                    defaultEntry = (Entry)v;
                    break;
                }
                if (defaultEntry == null) {
                    this.error(ISSUE_REGION_CANT_BE_ENTERED_USING_SHALLOW_HISTORY_NO_DEFAULT_ENTRY, (EObject)r, null, -1);
                    continue;
                }
                if (defaultEntry.getOutgoingTransitions().size() == 1) continue;
                this.error(ISSUE_REGION_CANT_BE_ENTERED_USING_SHALLOW_HISTORY_NON_CONNECTED_DEFAULT_ENTRY, (EObject)r, null, -1);
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void orthogonalStates(Synchronization fork) {
        this.orthogonalStates(fork, true);
        this.orthogonalStates(fork, false);
    }

    private void orthogonalStates(Synchronization fork, boolean searchTarget) {
        EList<Transition> transitions;
        EList<Transition> eList = transitions = searchTarget ? fork.getOutgoingTransitions() : fork.getIncomingTransitions();
        if (transitions.size() > 1) {
            Transition firstTransition = (Transition)transitions.get(0);
            Vertex vertex = searchTarget ? firstTransition.getTarget() : firstTransition.getSource();
            CompositeElement root = this.findCommonRootCompositeElement(vertex.getParentRegion().getComposite(), fork, searchTarget);
            if (root != null) {
                block0: for (Transition t : transitions) {
                    Region parentRegion = searchTarget ? t.getTarget().getParentRegion() : t.getSource().getParentRegion();
                    for (Transition transition : transitions) {
                        if (transition == t || !EcoreUtil.isAncestor((EObject)parentRegion, (EObject)(searchTarget ? transition.getTarget() : transition.getSource()))) continue;
                        this.error(searchTarget ? ISSUE_SYNCHRONIZATION_TARGET_STATES_NOT_ORTHOGONAL : ISSUE_SYNCHRONIZATION_SOURCE_STATES_NOT_ORTHOGONAL, (EObject)fork, null, -1);
                        continue block0;
                    }
                }
            } else {
                this.error(searchTarget ? ISSUE_SYNCHRONIZATION_TARGET_STATES_NOT_WITHIN_SAME_PARENTSTATE : ISSUE_SYNCHRONIZATION_SOURCE_STATES_NOT_WITHIN_SAME_PARENTSTATE, (EObject)fork, null, -1);
            }
        }
    }

    private CompositeElement findCommonRootCompositeElement(CompositeElement root, Synchronization fork, boolean searchTarget) {
        CompositeElement ret = root;
        if (ret != fork.getParentRegion().getComposite()) {
            for (Transition transition : searchTarget ? fork.getOutgoingTransitions() : fork.getIncomingTransitions()) {
                if (ret == null || EcoreUtil.isAncestor((EObject)ret, (EObject)(searchTarget ? transition.getTarget() : transition.getSource())) || !(ret.eContainer() instanceof Region)) continue;
                CompositeElement newRoot = ((Region)root.eContainer()).getComposite();
                ret = this.findCommonRootCompositeElement(newRoot, fork, searchTarget);
            }
            return ret;
        }
        return null;
    }

    public boolean isLanguageSpecific() {
        return false;
    }

    @Inject
    public void register(EValidatorRegistrar registrar) {
    }
}

