/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.model.stext.ui.help;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import de.itemis.utils.jface.viewers.help.HelpHoverProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.xtext.ui.editor.hover.html.DefaultEObjectHoverProvider;
import org.eclipse.xtext.ui.editor.hover.html.IXtextBrowserInformationControl;
import org.yakindu.sct.model.stext.ui.internal.STextActivator;

public class CustomCSSHelpHoverProvider
extends HelpHoverProvider {
    private String fgStyleSheet = null;
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.editor.hover.XtextEditorHover.font")
    private String fontSymbolicName = "org.eclipse.jdt.ui.javadocfont";
    @Inject
    @Named(value="stylesheet")
    private String styleSheetFileName;
    private HoverControlCreator hoverControlCreator;
    private DefaultEObjectHoverProvider.PresenterControlCreator presenterControlCreator;

    protected String getStyleSheet() {
        String css;
        if (this.fgStyleSheet == null) {
            this.fgStyleSheet = this.loadStyleSheet();
        }
        if ((css = this.fgStyleSheet) != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData(this.fontSymbolicName)[0];
            css = HTMLPrinter.convertTopLevelFont((String)css, (FontData)fontData);
        }
        return css;
    }

    /*
     * Loose catch block
     */
    protected String loadStyleSheet() {
        URL styleSheetURL = STextActivator.getInstance().getBundle().getEntry(this.styleSheetFileName);
        if (styleSheetURL != null) {
            BufferedReader reader = null;
            reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
            StringBuffer buffer = new StringBuffer(1500);
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append('\n');
                line = reader.readLine();
            }
            String string = buffer.toString();
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            return string;
            catch (IOException iOException) {
                try {}
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException3) {}
                return "";
            }
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.presenterControlCreator == null) {
            this.presenterControlCreator = new CustomPresenterControlCreator();
        }
        return this.presenterControlCreator;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.hoverControlCreator == null) {
            this.hoverControlCreator = new HoverControlCreator(this.getInformationPresenterControlCreator());
        }
        return this.hoverControlCreator;
    }

    public class CustomPresenterControlCreator
    extends DefaultEObjectHoverProvider.PresenterControlCreator {
        public CustomPresenterControlCreator() {
            super((DefaultEObjectHoverProvider)CustomCSSHelpHoverProvider.this);
        }

        protected void configureControl(IXtextBrowserInformationControl control, ToolBarManager tbm, String font) {
            OpenInHelpAction openHelpAction = new OpenInHelpAction();
            openHelpAction.setEnabled(true);
            tbm.add((IAction)openHelpAction);
            tbm.update(true);
        }
    }

    public final class HoverControlCreator
    extends AbstractReusableInformationControlCreator {
        private final IInformationControlCreator fInformationPresenterControlCreator;

        public HoverControlCreator(IInformationControlCreator informationPresenterControlCreator) {
            this.fInformationPresenterControlCreator = informationPresenterControlCreator;
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            String tooltipAffordanceString = EditorsUI.getTooltipAffordanceString();
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                String font = "org.eclipse.jdt.ui.javadocfont";
                BrowserInformationControl iControl = new BrowserInformationControl(parent, font, false){

                    public IInformationControlCreator getInformationPresenterControlCreator() {
                        return HoverControlCreator.this.fInformationPresenterControlCreator;
                    }
                };
                CustomCSSHelpHoverProvider.this.addLinkListener(iControl);
                return iControl;
            }
            return new DefaultInformationControl(parent, tooltipAffordanceString);
        }
    }

    private static final class OpenInHelpAction
    extends Action {
        public OpenInHelpAction() {
            this.setText("Open user guide");
            this.setImageDescriptor(ImageDescriptor.createFromImage((Image)PlatformUI.getWorkbench().getSharedImages().getImage("IMG_LCL_LINKTO_HELP")));
        }

        public void run() {
            IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
            helpSystem.displayHelp("org.yakindu.sct.ui.editor.stext_keyword");
        }
    }
}

