/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.palette.customaction.toolbox;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.uml.diagram.common.palette.customaction.providers.ITool;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractToolWizard
extends Wizard
implements ITool {
    private EditPart currentEditPart;
    private RecordingCommand command;
    private TransactionalEditingDomain domain;

    public AbstractToolWizard(EditPart part) {
        this.currentEditPart = part;
    }

    public EObject getEObject() {
        Object model = this.currentEditPart.getModel();
        if (model instanceof View) {
            View view = (View)model;
            return view.getElement();
        }
        return null;
    }

    public final boolean performFinish() {
        this.command = new RecordingCommand(this.domain){

            protected void doExecute() {
                AbstractToolWizard.this.doRun();
            }
        };
        return true;
    }

    public void setTransactionalEditingDomain(TransactionalEditingDomain dom) {
        this.domain = dom;
    }

    public RecordingCommand getCommand() {
        return this.command;
    }

    public EditPart getCurrentEditPart() {
        return this.currentEditPart;
    }

    public abstract void doRun();

    public void run(EditPart editPart) {
        try {
            RecordingCommand iCmd;
            final TransactionalEditingDomain editingDomain = ServiceUtilsForEditPart.getInstance().getTransactionalEditingDomain((Object)editPart);
            this.setTransactionalEditingDomain(editingDomain);
            WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)this);
            if (dialog.open() == 0 && (iCmd = this.getCommand()).canExecute()) {
                editingDomain.runExclusive(new Runnable(){

                    public void run() {
                        Display.getCurrent().asyncExec(new Runnable(){

                            public void run() {
                                editingDomain.getCommandStack().execute((Command)iCmd);
                            }
                        });
                    }
                });
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }
}

