/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.dnd.strategy.classifier;

import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.TransactionalDropStrategy;
import org.eclipse.papyrus.uml.diagram.composite.custom.helper.TypeHelper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassifierAsClassifierToStructureCompartmentDropStrategy
extends TransactionalDropStrategy {
    public String getLabel() {
        return "Classifier into structure compartment";
    }

    public String getID() {
        return "org.eclipse.papyrus.uml.diagram.dnd.ClassifierToStructureCompDrop";
    }

    public String getDescription() {
        return "Drops a classifier into the structure compartment of a class.";
    }

    public Image getImage() {
        return null;
    }

    public int getPriority() {
        return 0;
    }

    public void setOptions(Map<String, Object> options) {
    }

    public Command doGetCommand(Request request, EditPart targetEditPart) {
        if (!(request instanceof DropObjectsRequest)) {
            return null;
        }
        DropObjectsRequest dropRequest = (DropObjectsRequest)request;
        EObject targetSemanticElement = this.getTargetSemanticElement(targetEditPart);
        if (targetSemanticElement instanceof StructuredClassifier && dropRequest.getLocation() != null && targetEditPart instanceof GraphicalEditPart) {
            GraphicalEditPart gtEditPart = (GraphicalEditPart)targetEditPart;
            TypeHelper helper = new TypeHelper((TransactionalEditingDomain)this.getEditingDomain(targetEditPart));
            Point location = dropRequest.getLocation().getCopy();
            gtEditPart.getContentPane().translateToRelative((Translatable)location);
            gtEditPart.getContentPane().translateFromParent((Translatable)location);
            location.translate(gtEditPart.getContentPane().getClientArea().getLocation().getNegated());
            CompoundCommand cc = new CompoundCommand();
            for (EObject dropElement : this.getSourceEObjects(request)) {
                Type type;
                if (!(dropElement instanceof Type) || !(type = (Type)dropElement).allNamespaces().contains((Object)targetSemanticElement)) continue;
                cc.add((Command)helper.dropTypeOnClassifier(gtEditPart, (Type)dropElement, location));
            }
            return cc.canExecute() ? cc : null;
        }
        return null;
    }

    public String getCategoryID() {
        return "org.eclipse.papyrus.dnd.ClassifierToStructureCompDrop";
    }

    public String getCategoryLabel() {
        return "Drop a classifier into the structure compartment of a class";
    }
}

