/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.hyperlink.navigation;

import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.Activator;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.navigation.service.NavigableElement;
import org.eclipse.papyrus.infra.widgets.util.IRevealSemanticElement;
import org.eclipse.papyrus.infra.widgets.util.NavigationTarget;
import org.eclipse.swt.graphics.Image;

public class DiagramNavigableElement
implements NavigableElement {
    protected Diagram targetDiagram;

    public DiagramNavigableElement(Diagram target) {
        this.targetDiagram = target;
    }

    public String getLabel() {
        return "Navigate to diagram " + this.targetDiagram.getName();
    }

    public String getDescription() {
        return String.format("Navigates to the %s %s", this.targetDiagram.getType(), this.targetDiagram.getName());
    }

    public boolean navigate(NavigationTarget navigationContext) {
        try {
            IPageManager pageManager = ServiceUtilsForEObject.getInstance().getIPageManager((Object)this.targetDiagram);
            if (pageManager.isOpen((Object)this.targetDiagram)) {
                pageManager.selectPage((Object)this.targetDiagram);
            } else {
                pageManager.openPage((Object)this.targetDiagram);
            }
            return true;
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return false;
        }
    }

    @Deprecated
    public void navigate(IRevealSemanticElement revealSemanticElement) {
    }

    public Image getImage() {
        if (this.targetDiagram != null) {
            try {
                ILabelProvider labelProvider = ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)this.targetDiagram)).getLabelProvider();
                return labelProvider.getImage((Object)this.targetDiagram);
            }
            catch (ServiceException ex) {
                return null;
            }
        }
        return null;
    }

    public boolean isEnabled() {
        return this.targetDiagram != null;
    }
}

