/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.ui.wizards;

import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ocl.examples.emf.validation.validity.RootNode;
import org.eclipse.ocl.examples.emf.validation.validity.export.IValidityExporter;
import org.eclipse.ocl.examples.emf.validation.validity.ui.messages.ValidityUIMessages;
import org.eclipse.ocl.examples.emf.validation.validity.ui.plugin.ValidityUIPlugin;
import org.eclipse.ocl.examples.emf.validation.validity.ui.wizards.ExportValidationResultsFileWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ExportValidationResultsFileWizard
extends Wizard
implements INewWizard {
    @NonNull
    private final IValidityExporter exporter;
    @NonNull
    private final RootNode rootNode;
    private ExportValidationResultsFileWizardPage wizardPage;
    private Resource initialResource;

    public ExportValidationResultsFileWizard(@NonNull IWorkbench workbench, @NonNull IStructuredSelection initialSelection, @NonNull RootNode rootNode, @NonNull IValidityExporter exporter) {
        this.setWindowTitle(ValidityUIMessages.NewWizardPage_pageTitle);
        this.exporter = exporter;
        this.rootNode = rootNode;
        this.init(workbench, initialSelection);
    }

    public void export(final @NonNull Resource validatedResource, final @NonNull IPath savePath) {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                File exportedFile = new File(savePath.toString());
                String initialContents = ExportValidationResultsFileWizard.this.exporter.export(validatedResource, ExportValidationResultsFileWizard.this.rootNode, exportedFile.getName());
                byte[] byteArrayInputStream = initialContents.getBytes(Charset.forName("UTF-8"));
                try {
                    if (exportedFile.isAbsolute()) {
                        Files.write((byte[])byteArrayInputStream, (File)exportedFile);
                    } else {
                        ByteArrayInputStream contentStream = new ByteArrayInputStream(byteArrayInputStream);
                        IFile exportedIFile = ResourcesPlugin.getWorkspace().getRoot().getFile(savePath);
                        exportedIFile.create((InputStream)contentStream, true, monitor);
                    }
                }
                catch (CoreException e) {
                    ExportValidationResultsFileWizard.handleError(e.getCause(), true);
                }
                catch (IOException e) {
                    ExportValidationResultsFileWizard.handleError(e.getCause(), true);
                }
            }
        };
        try {
            op.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException e) {
            ExportValidationResultsFileWizard.handleError(e, false);
        }
        catch (InterruptedException e) {
            ExportValidationResultsFileWizard.handleError(e, false);
        }
    }

    private IFile getIResource(Resource resource) {
        if (resource == null) {
            return null;
        }
        URI resourceURI = resource.getURI();
        if (resourceURI == null) {
            return null;
        }
        if (resourceURI.isPlatform()) {
            Path resourcePath = new Path(resourceURI.toPlatformString(true));
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)resourcePath);
        }
        return null;
    }

    private static void handleError(Throwable t, boolean popup) {
        final String message = NLS.bind((String)ValidityUIMessages.NewWizardPage_internalErrorMessage, (Object)t.getMessage());
        Status status = t instanceof CoreException ? new Status(((CoreException)t).getStatus().getSeverity(), "org.eclipse.ocl.examples.emf.validation.validity.ui", message, t) : new Status(4, "org.eclipse.ocl.examples.emf.validation.validity.ui", message, t);
        ValidityUIPlugin.getPlugin().getLog().log((IStatus)status);
        if (popup) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable((IStatus)status){
                private final /* synthetic */ IStatus val$status;
                {
                    this.val$status = iStatus;
                }

                @Override
                public void run() {
                    ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)ValidityUIMessages.NewWizardPage_errorTitle, (String)message, (IStatus)this.val$status);
                }
            });
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IFile initialIResource = null;
        Object selected = selection.getFirstElement();
        if (selected instanceof Resource) {
            this.initialResource = (Resource)selected;
            initialIResource = this.getIResource(this.initialResource);
        }
        String preferredExtension = this.exporter.getPreferredExtension();
        if (initialIResource != null) {
            this.wizardPage = new ExportValidationResultsFileWizardPage(preferredExtension, (IResource)initialIResource);
            this.addPage((IWizardPage)this.wizardPage);
        }
    }

    public boolean performFinish() {
        Resource selectedResource2 = this.initialResource;
        IPath path = this.wizardPage.getNewExportedFilePath();
        if (selectedResource2 != null && path != null) {
            this.export(selectedResource2, path);
        }
        return true;
    }
}

