/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.ui.actions;

import java.net.URL;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ocl.examples.emf.validation.validity.AbstractNode;
import org.eclipse.ocl.examples.emf.validation.validity.ConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.LeafConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.ResultConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.ResultValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.ValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityModel;
import org.eclipse.ocl.examples.emf.validation.validity.ui.markers.GoToConstrainingNodeMarker;
import org.eclipse.ocl.examples.emf.validation.validity.ui.markers.GoToValidatableNodeMarker;
import org.eclipse.ocl.examples.emf.validation.validity.ui.messages.ValidityUIMessages;
import org.eclipse.ocl.examples.emf.validation.validity.ui.plugin.ValidityUIPlugin;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.IDEValidityManager;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public final class ShowElementInEditorAction
extends Action {
    private static final Logger logger = Logger.getLogger(ShowElementInEditorAction.class);
    @NonNull
    private final IDEValidityManager validityManager;
    @NonNull
    private final ISelectionProvider selectionProvider;

    @Nullable
    private static IFile findFile(Resource resource) {
        if (resource == null || resource.getURI() == null || !resource.getURI().isPlatform()) {
            return null;
        }
        Path resourcePath = new Path(resource.getURI().toPlatformString(true));
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)resourcePath);
        IProject iProject = iFile.getProject();
        if (!iProject.isAccessible() || !iFile.exists()) {
            return null;
        }
        return iFile;
    }

    public ShowElementInEditorAction(@NonNull IDEValidityManager validityManager, @NonNull ISelectionProvider selectionProvider) {
        super(ValidityUIMessages.ValidityView_Action_ShowInEditor_Title);
        this.validityManager = validityManager;
        this.selectionProvider = selectionProvider;
        this.setToolTipText(ValidityUIMessages.ValidityView_Action_ShowInEditor_ToolTipText);
        URL image = (URL)ValidityUIPlugin.INSTANCE.getImage(ValidityUIMessages.ValidityView_Action_ShowInEditor_ImageLocation);
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)image));
    }

    @Nullable
    private IMarker findGoToMarker(ValidityModel model, AbstractNode node) {
        IMarker goToMarker = null;
        if (node instanceof ResultConstrainingNode) {
            ResultConstrainingNode resultConstrainingNode = (ResultConstrainingNode)node;
            ValidatableNode validatableNode = resultConstrainingNode.getResultValidatableNode().getParent();
            if (validatableNode != null && this.getValidatableNodeMarker(validatableNode) != null) {
                goToMarker = this.getValidatableNodeMarker(validatableNode).getIMarker();
            }
        } else if (node instanceof ResultValidatableNode) {
            ResultValidatableNode validatableNode = (ResultValidatableNode)node;
            ConstrainingNode constrainingNode = validatableNode.getResultConstrainingNode().getParent();
            if (constrainingNode instanceof LeafConstrainingNode && this.getLeafConstrainingNodeMarker((LeafConstrainingNode)constrainingNode) != null) {
                goToMarker = this.getLeafConstrainingNodeMarker((LeafConstrainingNode)constrainingNode).getIMarker();
            }
        } else if (node instanceof LeafConstrainingNode && this.getLeafConstrainingNodeMarker((LeafConstrainingNode)node) != null) {
            goToMarker = this.getLeafConstrainingNodeMarker((LeafConstrainingNode)node).getIMarker();
        } else if (node instanceof ValidatableNode && this.getValidatableNodeMarker((ValidatableNode)node) != null) {
            goToMarker = this.getValidatableNodeMarker((ValidatableNode)node).getIMarker();
        }
        return goToMarker;
    }

    @Nullable
    private IWorkbenchPage getActivePage() {
        IWorkbenchWindow activeWindow;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (activeWindow = workbench.getActiveWorkbenchWindow()) != null) {
            return activeWindow.getActivePage();
        }
        return null;
    }

    public GoToConstrainingNodeMarker getLeafConstrainingNodeMarker(@NonNull LeafConstrainingNode leafConstrainingNode) {
        IFile file;
        Resource resource = leafConstrainingNode.getConstraintResource();
        if (resource != null && (file = ShowElementInEditorAction.findFile(resource)) != null) {
            return new GoToConstrainingNodeMarker(file);
        }
        return null;
    }

    public GoToValidatableNodeMarker getValidatableNodeMarker(@NonNull ValidatableNode validatableNode) {
        IFile containingFile = ShowElementInEditorAction.findFile(validatableNode.getConstrainedObject().eResource());
        if (containingFile != null) {
            return new GoToValidatableNodeMarker(containingFile, validatableNode.getConstrainedObject());
        }
        return null;
    }

    public void run() {
        ISelection selection = this.selectionProvider.getSelection();
        if (selection instanceof StructuredSelection) {
            Object selectedObject = ((StructuredSelection)selection).getFirstElement();
            ValidityModel model = this.validityManager.getModel();
            IWorkbenchPage activePage = this.getActivePage();
            if (!(selectedObject instanceof AbstractNode) || activePage == null || model == null) {
                return;
            }
            IMarker goToMarker = this.findGoToMarker(model, (AbstractNode)selectedObject);
            if (goToMarker != null) {
                try {
                    IDE.openEditor((IWorkbenchPage)activePage, (IMarker)goToMarker);
                }
                catch (PartInitException exception) {
                    logger.error((Object)"Failed to open in the Editor ", (Throwable)exception);
                    EcorePlugin.INSTANCE.log((Object)exception);
                }
            }
        }
    }
}

