/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.ui.actions;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ocl.examples.emf.validation.validity.ConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.LeafConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.ResultConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.ResultValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.ValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.locator.ConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.ui.locator.ConstraintUILocator;
import org.eclipse.ocl.examples.emf.validation.validity.ui.messages.ValidityUIMessages;
import org.eclipse.ocl.examples.emf.validation.validity.ui.plugin.ValidityUIPlugin;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.ValidityView;
import org.eclipse.swt.widgets.Shell;

public final class DebugValidityAction
extends Action
implements ISelectionChangedListener {
    @NonNull
    protected final ValidityView validityView;
    @NonNull
    protected final ISelectionProvider selectionProvider;

    public DebugValidityAction(@NonNull ValidityView validityView, @NonNull ISelectionProvider selectionProvider) {
        super(ValidityUIMessages.ValidityView_Action_DebugValidity_Title);
        this.validityView = validityView;
        this.selectionProvider = selectionProvider;
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        this.setToolTipText(ValidityUIMessages.ValidityView_Action_DebugValidity_ToolTipText);
        URL image = (URL)ValidityUIPlugin.INSTANCE.getImage(ValidityUIMessages.ValidityView_Action_DebugValidity_ImageLocation);
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)image));
    }

    @NonNull
    protected List<ResultConstrainingNode> getEnabledResultConstrainingNodes(@NonNull ConstrainingNode constrainingNode) {
        ResultConstrainingNode resultConstrainingNode;
        ArrayList<ResultConstrainingNode> resultConstrainingNodes = new ArrayList<ResultConstrainingNode>();
        if (constrainingNode instanceof ResultConstrainingNode && (resultConstrainingNode = (ResultConstrainingNode)constrainingNode).isEnabled()) {
            resultConstrainingNodes.add(resultConstrainingNode);
        }
        TreeIterator tit = constrainingNode.eAllContents();
        while (tit.hasNext()) {
            ResultConstrainingNode resultConstrainingNode2;
            Object eObject = tit.next();
            if (!(eObject instanceof ResultConstrainingNode) || !(resultConstrainingNode2 = (ResultConstrainingNode)eObject).isEnabled()) continue;
            resultConstrainingNodes.add(resultConstrainingNode2);
        }
        return resultConstrainingNodes;
    }

    @NonNull
    protected List<ResultValidatableNode> getEnabledResultValidatableNodes(@NonNull ValidatableNode validatableNode) {
        ResultValidatableNode resultValidatableNode;
        ArrayList<ResultValidatableNode> resultValidatableNodes = new ArrayList<ResultValidatableNode>();
        if (validatableNode instanceof ResultValidatableNode && (resultValidatableNode = (ResultValidatableNode)validatableNode).isEnabled()) {
            resultValidatableNodes.add(resultValidatableNode);
        }
        TreeIterator tit = validatableNode.eAllContents();
        while (tit.hasNext()) {
            ResultValidatableNode resultValidatableNode2;
            Object eObject = tit.next();
            if (!(eObject instanceof ResultValidatableNode) || !(resultValidatableNode2 = (ResultValidatableNode)eObject).isEnabled()) continue;
            resultValidatableNodes.add(resultValidatableNode2);
        }
        return resultValidatableNodes;
    }

    public void run() {
        ISelection selection = this.selectionProvider.getSelection();
        if (selection instanceof StructuredSelection) {
            ResultConstrainingNode resultConstrainingNode = null;
            Object selectedObject = ((StructuredSelection)selection).getFirstElement();
            if (selectedObject instanceof ConstrainingNode) {
                resultConstrainingNode = this.getEnabledResultConstrainingNodes((ConstrainingNode)selectedObject).get(0);
            } else if (selectedObject instanceof ValidatableNode) {
                ResultValidatableNode resultValidatableNode = this.getEnabledResultValidatableNodes((ValidatableNode)selectedObject).get(0);
                resultConstrainingNode = resultValidatableNode.getResultConstrainingNode();
            }
            if (resultConstrainingNode != null) {
                final Shell shell = this.validityView.getViewSite().getShell();
                ConstrainingNode eParent = resultConstrainingNode.getParent();
                if (eParent instanceof LeafConstrainingNode) {
                    final ResultConstrainingNode finalResultConstrainingNode = resultConstrainingNode;
                    ConstraintLocator constraintLocator = ((LeafConstrainingNode)eParent).getConstraintLocator();
                    if (constraintLocator instanceof ConstraintUILocator) {
                        final ConstraintUILocator uiConstraintLocator = (ConstraintUILocator)constraintLocator;
                        Thread launchingThread = new Thread("DebugConstraintLauncher"){

                            @Override
                            public void run() {
                                try {
                                    if (!uiConstraintLocator.debug(finalResultConstrainingNode, DebugValidityAction.this.validityView, (IProgressMonitor)new NullProgressMonitor())) {
                                        this.openError(shell, "Debugging failed for '" + uiConstraintLocator.getName() + "'.");
                                    }
                                }
                                catch (Exception e) {
                                    this.openError(shell, "Debugging failed for '" + uiConstraintLocator.getName() + "'." + e.toString());
                                }
                            }

                            protected void openError(final Shell shell2, final String message) {
                                if (!shell2.isDisposed()) {
                                    shell2.getDisplay().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            MessageDialog.openError((Shell)shell2, (String)"Constraint Debug Launcher", (String)message);
                                        }
                                    });
                                }
                            }
                        };
                        launchingThread.start();
                        return;
                    }
                    MessageDialog.openError((Shell)shell, (String)"Constraint Debug Launcher", (String)("Debugging not supported for '" + constraintLocator.getName() + "'."));
                }
            }
            assert (false);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = this.selectionProvider.getSelection();
        if (selection instanceof StructuredSelection) {
            Object selectedObject = ((StructuredSelection)selection).getFirstElement();
            if (selectedObject instanceof ConstrainingNode) {
                this.setEnabled(this.getEnabledResultConstrainingNodes((ConstrainingNode)selectedObject).size() == 1);
            } else if (selectedObject instanceof ValidatableNode) {
                this.setEnabled(this.getEnabledResultValidatableNodes((ValidatableNode)selectedObject).size() == 1);
            } else {
                this.setEnabled(false);
            }
        }
    }
}

