/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.event.CellSelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.ColumnSelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.ISelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.RowSelectionEvent;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.provider.TableStructuredSelection;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;
import org.eclipse.ui.services.IDisposable;

public class TableSelectionProvider
implements ISelectionProvider,
IDisposable {
    private SelectionLayer selectionLayer;
    private final ILayerListener selectionListener;
    private ISelection currentSelection;
    private final List<ISelectionChangedListener> listeners;
    private INattableModelManager manager;

    public TableSelectionProvider(INattableModelManager manager, SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
        this.selectionListener = new ILayerListener(){

            public void handleLayerEvent(ILayerEvent event) {
                if (event instanceof ISelectionEvent) {
                    TableSelectionProvider.this.calculateAndStoreNewSelection(event);
                }
            }
        };
        this.selectionLayer.addLayerListener(this.selectionListener);
        this.currentSelection = new StructuredSelection();
        this.listeners = new ArrayList<ISelectionChangedListener>();
        this.manager = manager;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public synchronized ISelection getSelection() {
        return this.currentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void setSelection(ISelection selection) {
        if (this.currentSelection.equals(selection)) {
            return;
        }
        this.currentSelection = selection;
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.currentSelection);
        for (ISelectionChangedListener current : this.listeners) {
            current.selectionChanged(event);
        }
    }

    protected void calculateAndStoreNewSelection(ILayerEvent event) {
        StructuredSelection newSelection;
        ArrayList<Object> selection = new ArrayList<Object>();
        if (event instanceof ISelectionEvent) {
            List<PositionCoordinate> selectedCells = Arrays.asList(this.selectionLayer.getSelectedCellPositions());
            TableSelectionWrapper wrapper = new TableSelectionWrapper(selectedCells);
            if (event instanceof CellSelectionEvent) {
                PositionCoordinate[] positionCoordinateArray = this.selectionLayer.getSelectedCellPositions();
                int n = positionCoordinateArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object value;
                    int rowPos;
                    PositionCoordinate current1 = positionCoordinateArray[n2];
                    int colPos = current1.getColumnPosition();
                    ILayerCell cell = this.selectionLayer.getCellByPosition(colPos, rowPos = current1.getRowPosition());
                    if (cell != null && (value = cell.getDataValue()) != null) {
                        if (value instanceof Collection) {
                            for (Object current : (Collection)value) {
                                selection.add(current);
                            }
                        } else {
                            selection.add(value);
                        }
                    }
                    ++n2;
                }
            } else if (event instanceof RowSelectionEvent) {
                int[] rows;
                this.selectionLayer.getFullySelectedRowPositions();
                int[] nArray = rows = this.selectionLayer.getFullySelectedRowPositions();
                int n = rows.length;
                int n3 = 0;
                while (n3 < n) {
                    int i = nArray[n3];
                    Object el = this.manager.getRowElement(i);
                    if (el != null) {
                        el = AxisUtils.getRepresentedElement(el);
                        selection.add(el);
                    }
                    ++n3;
                }
            } else if (event instanceof ColumnSelectionEvent) {
                int[] selectedColumn;
                int[] nArray = selectedColumn = this.selectionLayer.getFullySelectedColumnPositions();
                int n = selectedColumn.length;
                int n4 = 0;
                while (n4 < n) {
                    int i = nArray[n4];
                    Object el = this.manager.getColumnElement(i);
                    if (el != null) {
                        el = AxisUtils.getRepresentedElement(el);
                        selection.add(el);
                    }
                    ++n4;
                }
            }
            newSelection = new TableStructuredSelection(selection, wrapper);
        } else {
            newSelection = new StructuredSelection();
        }
        this.setSelection((ISelection)newSelection);
    }

    public void dispose() {
        this.selectionLayer.removeLayerListener(this.selectionListener);
        this.selectionLayer = null;
    }
}

