/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.provider;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.emf.providers.EMFLabelProvider;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableproblem.Problem;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableproblem.StringResolutionProblem;
import org.eclipse.papyrus.infra.services.labelprovider.service.IFilteredLabelProvider;

public class ProblemLabelProvider
extends EMFLabelProvider
implements IFilteredLabelProvider {
    public boolean accept(Object element) {
        return element instanceof Problem;
    }

    protected String getText(EObject element) {
        Problem pb = (Problem)element;
        if (pb instanceof StringResolutionProblem) {
            return ((StringResolutionProblem)pb).getValueAsString();
        }
        return pb.getDescription();
    }

    public String getTooltipText(EObject element) {
        if (element instanceof Problem) {
            Problem problem = (Problem)element;
            StringBuilder builder = new StringBuilder();
            if (problem instanceof StringResolutionProblem) {
                EList unresolvedStrings = ((StringResolutionProblem)problem).getUnresolvedString();
                builder.append(NLS.bind((String)Messages.ProblemLabelProvider_StringsValuesCanBeResolved, (Object)unresolvedStrings.size()));
                if (unresolvedStrings.size() == 1) {
                    builder.append(" ");
                    builder.append((String)unresolvedStrings.get(0));
                } else {
                    Iterator iterOnString = ((StringResolutionProblem)problem).getUnresolvedString().iterator();
                    while (iterOnString.hasNext()) {
                        builder.append("\n\t- ");
                        builder.append((String)iterOnString.next());
                    }
                }
            } else {
                builder.append(problem.getDescription());
            }
            return builder.toString();
        }
        return null;
    }
}

