/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.painter;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.resize.command.RowResizeCommand;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableproblem.Problem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class CellPainterWithUnderlinedError
extends TextPainter {
    private final int[] yErrorOffsets;

    public CellPainterWithUnderlinedError(boolean wrapText, boolean paintBg) {
        super(wrapText, paintBg);
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 1;
        this.yErrorOffsets = nArray;
    }

    public void paintCell(ILayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
        block11: {
            Rectangle originalClipping;
            block13: {
                String[] lines;
                int contentHeight;
                String text;
                int fontHeight;
                boolean hasError;
                boolean strikethrough;
                boolean underline;
                IStyle cellStyle;
                block12: {
                    int y;
                    int x;
                    block14: {
                        if (this.paintBg) {
                            super.paintCell(cell, gc, rectangle, configRegistry);
                        }
                        if (!this.paintFg) break block11;
                        originalClipping = gc.getClipping();
                        gc.setClipping(rectangle.intersection(originalClipping));
                        cellStyle = CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry);
                        this.setupGCFromConfig(gc, cellStyle);
                        underline = this.renderUnderlined(cellStyle);
                        strikethrough = this.renderStrikethrough(cellStyle);
                        hasError = this.hasError(cell);
                        fontHeight = gc.getFontMetrics().getHeight();
                        text = this.convertDataType(cell, configRegistry);
                        text = this.getTextToDisplay(cell, gc, rectangle.width, text);
                        int numberOfNewLines = this.getNumberOfNewLines(text);
                        contentHeight = fontHeight * numberOfNewLines + this.spacing * 2;
                        int contentToCellDiff = cell.getBounds().height - rectangle.height;
                        if (this.performRowResize(contentHeight, rectangle)) {
                            ILayer layer = cell.getLayer();
                            layer.doCommand((ILayerCommand)new RowResizeCommand(layer, cell.getRowPosition(), contentHeight + contentToCellDiff));
                        }
                        if (numberOfNewLines != 1) break block12;
                        int contentWidth = Math.min(this.getLengthFromCache(gc, text), rectangle.width);
                        gc.drawText(text, rectangle.x + CellStyleUtil.getHorizontalAlignmentPadding((IStyle)cellStyle, (Rectangle)rectangle, (int)contentWidth) + this.spacing, rectangle.y + CellStyleUtil.getVerticalAlignmentPadding((IStyle)cellStyle, (Rectangle)rectangle, (int)contentHeight) + this.spacing, 3);
                        if (!hasError && !underline && !strikethrough) break block13;
                        x = rectangle.x + CellStyleUtil.getHorizontalAlignmentPadding((IStyle)cellStyle, (Rectangle)rectangle, (int)contentWidth) + this.spacing;
                        y = rectangle.y + CellStyleUtil.getVerticalAlignmentPadding((IStyle)cellStyle, (Rectangle)rectangle, (int)contentHeight) + this.spacing;
                        if (!hasError) break block14;
                        int underlineY = y + fontHeight - gc.getFontMetrics().getDescent() / 2;
                        Color previousColor = gc.getForeground();
                        gc.setForeground(GUIHelper.COLOR_RED);
                        int startX = x;
                        --underlineY;
                        int index = 0;
                        while (startX <= x + gc.textExtent((String)text).x) {
                            gc.drawPoint(startX, underlineY + this.yErrorOffsets[index % 4]);
                            ++index;
                            ++startX;
                        }
                        gc.setForeground(previousColor);
                        break block13;
                    }
                    if (underline) {
                        int underlineY = y + fontHeight - gc.getFontMetrics().getDescent() / 2;
                        gc.drawLine(x, underlineY, x + gc.textExtent((String)text).x, underlineY);
                    }
                    if (!strikethrough) break block13;
                    int strikeY = y + fontHeight / 2 + gc.getFontMetrics().getLeading() / 2;
                    gc.drawLine(x, strikeY, x + gc.textExtent((String)text).x, strikeY);
                    break block13;
                }
                int yStartPos = rectangle.y + CellStyleUtil.getVerticalAlignmentPadding((IStyle)cellStyle, (Rectangle)rectangle, (int)contentHeight);
                String[] stringArray = lines = text.split("\n");
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    int lineContentWidth = Math.min(this.getLengthFromCache(gc, line), rectangle.width);
                    gc.drawText(line, rectangle.x + CellStyleUtil.getHorizontalAlignmentPadding((IStyle)cellStyle, (Rectangle)rectangle, (int)lineContentWidth) + this.spacing, yStartPos + this.spacing, 3);
                    if (hasError || underline || strikethrough) {
                        int underlineY;
                        int x = rectangle.x + CellStyleUtil.getHorizontalAlignmentPadding((IStyle)cellStyle, (Rectangle)rectangle, (int)lineContentWidth) + this.spacing;
                        int y = yStartPos + this.spacing;
                        if (hasError) {
                            underlineY = y + fontHeight - gc.getFontMetrics().getDescent() / 2;
                            Color previousColor = gc.getForeground();
                            gc.setForeground(GUIHelper.COLOR_RED);
                            int startX = x;
                            --underlineY;
                            int index = 0;
                            while (startX <= x + gc.textExtent((String)line).x) {
                                gc.drawPoint(startX, underlineY + this.yErrorOffsets[index % 4]);
                                ++index;
                                ++startX;
                            }
                            gc.setForeground(previousColor);
                        } else {
                            if (underline) {
                                underlineY = y + fontHeight - gc.getFontMetrics().getDescent() / 2;
                                gc.drawLine(x, underlineY, x + gc.textExtent((String)line).x, underlineY);
                            }
                            if (strikethrough) {
                                int strikeY = y + fontHeight / 2 + gc.getFontMetrics().getLeading() / 2;
                                gc.drawLine(x, strikeY, x + gc.textExtent((String)line).x, strikeY);
                            }
                        }
                    }
                    yStartPos += fontHeight;
                    ++n2;
                }
            }
            gc.setClipping(originalClipping);
        }
    }

    protected boolean hasError(ILayerCell cell) {
        Object value = cell.getDataValue();
        boolean hasError = false;
        if (value instanceof Problem) {
            hasError = true;
        } else if (value instanceof Collection) {
            Iterator iter = ((Collection)value).iterator();
            while (!hasError && iter.hasNext()) {
                hasError = iter.next() instanceof Problem;
            }
        }
        return hasError;
    }
}

