/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.dialog.PasteImportStatusDialog;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IPasteConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.PasteEObjectConfiguration;
import org.eclipse.papyrus.infra.nattable.parsers.CSVParser;
import org.eclipse.papyrus.infra.nattable.parsers.CellIterator;
import org.eclipse.papyrus.infra.nattable.parsers.RowIterator;
import org.eclipse.papyrus.infra.nattable.provider.PasteEObjectAxisInNattableCommandProvider;
import org.eclipse.papyrus.infra.nattable.utils.AxisConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.CSVPasteHelper;
import org.eclipse.papyrus.infra.nattable.utils.CreatableEObjectAxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.PasteConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.PasteEnablementStatus;
import org.eclipse.papyrus.infra.nattable.utils.PasteModeEnumeration;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractPasteImportInNattableManager {
    protected final CSVPasteHelper pasteHelper;
    protected final INattableModelManager tableManager;
    private boolean useProgressMonitorDialog;
    private static final String INVERTED_MESSAGE = Messages.AbstractPasteImportInNattableManager_INVERTED_MESSAGE;

    public AbstractPasteImportInNattableManager(INattableModelManager tableManager, CSVPasteHelper pasteHelper, boolean useProgressMonitorDialog) {
        this.pasteHelper = pasteHelper;
        this.tableManager = tableManager;
        this.useProgressMonitorDialog = useProgressMonitorDialog;
    }

    public boolean doPaste() {
        if (this.tableManager.getTable().isInvertAxis()) {
            new PasteImportStatusDialog(Display.getDefault().getActiveShell(), INVERTED_MESSAGE).open();
            return false;
        }
        PasteEnablementStatus pasteStatus = this.findPasteModeFromTableConfiguration(this.tableManager);
        if (pasteStatus.getPasteMode() == PasteModeEnumeration.PASTE_EOBJECT_ROW_OR_COLUMN) {
            boolean value = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)PasteImportStatusDialog.DIALOG_TITLE, (String)Messages.AbstractPasteImportInNattableManager_WhatAreYouPasting);
            if (value) {
                pasteStatus.getColumnStatus().add((IStatus)new Status(8, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInNattableManager_TheUserChosesToPasteRows));
            } else {
                pasteStatus.getRowStatus().add((IStatus)new Status(8, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInNattableManager_TheUserChosesToPasteColumns));
            }
        }
        PasteModeEnumeration pasteMode = pasteStatus.getPasteMode();
        switch (pasteMode) {
            case PASTE_NO_CONFIGURATION: {
                return this.openPasteWithNoConfigurationDialog();
            }
            case CANT_PASTE: {
                return this.openCantPasteDialog(pasteStatus);
            }
            case PASTE_EOBJECT_ROW: {
                return this.pasteRow(this.tableManager, pasteStatus, this.pasteHelper);
            }
            case PASTE_EOBJECT_COLUMN: {
                return this.pasteColumn(this.tableManager, pasteStatus, this.pasteHelper);
            }
            case PASTE_EOBJECT_ROW_OR_COLUMN: {
                break;
            }
        }
        return false;
    }

    private boolean openCantPasteDialog(PasteEnablementStatus pasteStatus) {
        MultiStatus rowStatus = pasteStatus.getRowStatus();
        MultiStatus columnStatus = pasteStatus.getColumnStatus();
        if (rowStatus == null && columnStatus != null) {
            new PasteImportStatusDialog(Display.getCurrent().getActiveShell(), this.getFirstNonOKStatus((IStatus)columnStatus).getMessage()).open();
        } else if (columnStatus == null && rowStatus != null) {
            new PasteImportStatusDialog(Display.getCurrent().getActiveShell(), this.getFirstNonOKStatus((IStatus)rowStatus).getMessage()).open();
        } else if (columnStatus != null && rowStatus != null) {
            StringBuffer buffer = new StringBuffer(Messages.AbstractPasteImportInNattableManager_NoPasteConfiguration);
            buffer.append(Messages.AbstractPasteImportInNattableManager_PasteRowsError);
            buffer.append(this.getFirstNonOKStatus((IStatus)rowStatus).getMessage());
            buffer.append(Messages.AbstractPasteImportInNattableManager_PasteColumnsError);
            buffer.append(this.getFirstNonOKStatus((IStatus)columnStatus).getMessage());
            new PasteImportStatusDialog(Display.getDefault().getActiveShell(), buffer.toString()).open();
        } else {
            this.openPasteWithNoConfigurationDialog();
        }
        return true;
    }

    private IStatus getFirstNonOKStatus(IStatus status) {
        if (status != null && !status.isOK()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus current = iStatusArray[n2];
                if (!current.isOK()) {
                    if (current.isMultiStatus()) {
                        return this.getFirstNonOKStatus(current);
                    }
                    return current;
                }
                ++n2;
            }
        }
        return null;
    }

    private boolean openPasteWithNoConfigurationDialog() {
        new PasteImportStatusDialog(Display.getDefault().getActiveShell(), Messages.AbstractPasteImportInNattableManager_NoPasteConfiguration2, 2).open();
        return true;
    }

    private boolean pasteColumn(INattableModelManager manager, PasteEnablementStatus pasteStatus, CSVPasteHelper pasteHelper) {
        return false;
    }

    private boolean pasteRow(INattableModelManager manager, PasteEnablementStatus pasteStatus, CSVPasteHelper pasteHelper) {
        Reader reader = this.createReader();
        IStatus status = this.verifyColumnCountOnFirstLine(manager, reader);
        try {
            reader.close();
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        if (!status.isOK()) {
            new PasteImportStatusDialog(Display.getDefault().getActiveShell(), status.getMessage()).open();
            return false;
        }
        this.paste(manager, pasteStatus, this.useProgressMonitorDialog, this.createReader(), this.getDataSize());
        return true;
    }

    private IStatus verifyColumnCountOnFirstLine(INattableModelManager tableManager, Reader reader) {
        int axisCount = tableManager.getColumnCount();
        CSVParser parser = this.pasteHelper.createParser(reader);
        RowIterator rowIter = parser.parse();
        int nbCell = 0;
        if (rowIter.hasNext()) {
            CellIterator cellIter = (CellIterator)rowIter.next();
            while (cellIter.hasNext()) {
                cellIter.next();
                ++nbCell;
            }
        }
        if (axisCount == 0) {
            return new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInNattableManager_TheTableDoesntHaveColumns);
        }
        if (axisCount == nbCell) {
            return new Status(0, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInNattableManager_NumberOfColumnsAreEquals);
        }
        return new Status(0, "org.eclipse.papyrus.infra.nattable", NLS.bind((String)Messages.AbstractPasteImportInNattableManager_NumberOfColumnsAreNotEquals, (Object)nbCell, (Object)axisCount));
    }

    private void paste(INattableModelManager manager, PasteEnablementStatus status, boolean useProgressMonitorDialog, Reader reader, long totalSize) {
        PasteEObjectAxisInNattableCommandProvider commandProvider = null;
        switch (status.getPasteMode()) {
            case PASTE_EOBJECT_ROW: {
                commandProvider = new PasteEObjectAxisInNattableCommandProvider(manager, false, reader, this.pasteHelper, totalSize);
                break;
            }
            case PASTE_EOBJECT_COLUMN: {
                commandProvider = new PasteEObjectAxisInNattableCommandProvider(manager, true, reader, this.pasteHelper, totalSize);
                break;
            }
        }
        if (commandProvider != null) {
            commandProvider.executePasteFromStringCommand(useProgressMonitorDialog);
        }
    }

    private PasteEnablementStatus findPasteModeFromTableConfiguration(INattableModelManager tableManager) {
        MultiStatus pasteRowsStatus = AbstractPasteImportInNattableManager.canPasteAxis_verifyPasteConfiguration(tableManager, false);
        MultiStatus pasteColumnsStatus = AbstractPasteImportInNattableManager.canPasteAxis_verifyPasteConfiguration(tableManager, true);
        PasteEnablementStatus pasteStatus = new PasteEnablementStatus(pasteColumnsStatus, pasteRowsStatus);
        return pasteStatus;
    }

    private static MultiStatus canPasteAxis_verifyPasteConfiguration(INattableModelManager tableManager, boolean columnAxis) {
        IPasteConfiguration conf = (IPasteConfiguration)AxisConfigurationUtils.getIAxisConfigurationUsedInTable(tableManager.getTable(), NattableaxisconfigurationPackage.eINSTANCE.getPasteEObjectConfiguration(), columnAxis);
        String pluginId = "org.eclipse.papyrus.infra.nattable";
        String axisName = columnAxis ? Messages.AbstractPasteImportInNattableManager_column : Messages.AbstractPasteImportInNattableManager_row;
        MultiStatus status = null;
        if (conf instanceof PasteEObjectConfiguration) {
            status = new MultiStatus("org.eclipse.papyrus.infra.nattable", 0, NLS.bind((String)Messages.AbstractPasteImportInNattableManager_EnablementStatusForPasteInTheTable, (Object)axisName), null);
            status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", NLS.bind((String)Messages.AbstractPasteImportInNattableManager_TheTableHasAConfigurationToPaste, (Object)axisName)));
            if (status.isOK()) {
                PasteEObjectConfiguration pasteConfiguration = (PasteEObjectConfiguration)conf;
                status.add(PasteConfigurationUtils.hasConsistentPasteEObjectConfiguration(pasteConfiguration));
                if (status.isOK()) {
                    EStructuralFeature containmentFeature = pasteConfiguration.getPasteElementContainementFeature();
                    if (tableManager.getTable().getContext().eClass().getEAllStructuralFeatures().contains((Object)containmentFeature)) {
                        status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInNattableManager_TheContextOfTheTableHasTheContainmentFeatureDefinedForThePaste));
                    } else {
                        status.add((IStatus)new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInNattableManager_TheContextOfTheTableHasNotTheContainmentFeatureDefinedForThePaste));
                    }
                    if (status.isOK()) {
                        String elementId = pasteConfiguration.getPastedElementId();
                        if (CreatableEObjectAxisUtils.getCreatableElementIds(tableManager, columnAxis).contains(elementId)) {
                            status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", NLS.bind((String)Messages.AbstractPasteImportInNattableManager_TheTableCanCreateElement, (Object)elementId, (Object)axisName)));
                        } else {
                            status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", NLS.bind((String)Messages.AbstractPasteImportInNattableManager_TheTableCantCreateElement, (Object)elementId, (Object)axisName)));
                        }
                    }
                }
            }
        }
        return status;
    }

    protected abstract Reader createReader();

    protected abstract long getDataSize();
}

