/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.layer;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.edit.command.EditCellCommand;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.papyrus.infra.nattable.configuration.PapyrusGridLayerConfiguration;
import org.eclipse.papyrus.infra.nattable.handler.TransactionalEditCellCommandHandler;

public class PapyrusGridLayer
extends GridLayer {
    private final TransactionalEditingDomain domain;

    public PapyrusGridLayer(TransactionalEditingDomain domain, ILayer bodyLayer, ILayer columnHeaderLayer, ILayer rowHeaderLayer, ILayer cornerLayer) {
        super(bodyLayer, columnHeaderLayer, rowHeaderLayer, cornerLayer);
        this.domain = domain;
    }

    public PapyrusGridLayer(TransactionalEditingDomain domain, ILayer bodyLayer, ILayer columnHeaderLayer, ILayer rowHeaderLayer, ILayer cornerLayer, boolean useDefaultConfiguration) {
        super(bodyLayer, columnHeaderLayer, rowHeaderLayer, cornerLayer, useDefaultConfiguration);
        this.domain = domain;
    }

    public PapyrusGridLayer(TransactionalEditingDomain domain, boolean useDefaultConfiguration) {
        super(useDefaultConfiguration);
        this.domain = domain;
    }

    protected void init(boolean useDefaultConfiguration) {
        this.registerCommandHandlers();
        if (useDefaultConfiguration) {
            this.addConfiguration((IConfiguration)new PapyrusGridLayerConfiguration((CompositeLayer)this));
        }
    }

    public void registerCommandHandler(ILayerCommandHandler<?> commandHandler) {
        if (commandHandler.getCommandClass() == EditCellCommand.class) {
            commandHandler = new TransactionalEditCellCommandHandler(this.domain);
        }
        super.registerCommandHandler(commandHandler);
    }
}

