/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.dataprovider;

import org.eclipse.papyrus.infra.nattable.dataprovider.AbstractHeaderDataProvider;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AbstractHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.HeaderAxisConfigurationManagementUtils;

public class RowHeaderDataProvider
extends AbstractHeaderDataProvider {
    private int axisCount;

    public RowHeaderDataProvider(INattableModelManager manager) {
        super(manager);
    }

    @Override
    public int getColumnCount() {
        return this.axisCount;
    }

    public Object getDataValue(int columnIndex, int rowIndex) {
        switch (this.axisCount) {
            case 0: {
                return null;
            }
            case 1: {
                if (this.displayFilter) {
                    return null;
                }
                if (this.displayIndex) {
                    return this.getAxisIndex(rowIndex);
                }
                if (this.displayLabel) {
                    return this.manager.getRowElement(rowIndex);
                }
            }
            case 2: {
                if (this.displayFilter) break;
                if (columnIndex == 0) {
                    return this.getAxisIndex(rowIndex);
                }
                if (columnIndex != 1) break;
                return this.manager.getRowElement(rowIndex);
            }
            case 3: {
                if (this.displayFilter) break;
                if (columnIndex == 0) {
                    return this.getAxisIndex(rowIndex);
                }
                if (columnIndex != 1) break;
                return this.manager.getRowElement(rowIndex);
            }
        }
        return null;
    }

    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected AbstractHeaderAxisConfiguration getAxisConfiguration() {
        return HeaderAxisConfigurationManagementUtils.getAbstractHeaderAxisConfigurationUsedInTable(this.manager.getTable());
    }

    @Override
    protected void updateAxisCount() {
        int newAxisCOunt = 0;
        if (this.displayIndex) {
            ++newAxisCOunt;
        }
        if (this.displayLabel) {
            ++newAxisCOunt;
        }
        this.axisCount = newAxisCOunt;
    }
}

