/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.config.DefaultEditConfiguration;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.emf.providers.EMFLabelProvider;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.accumulator.CustomRowOverrideLabelAccumulator;
import org.eclipse.papyrus.infra.nattable.celleditor.config.CellEditorConfigurationFactory;
import org.eclipse.papyrus.infra.nattable.celleditor.config.IAxisCellEditorConfiguration;
import org.eclipse.papyrus.infra.nattable.layerstack.BodyLayerStack;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.CellEditorDeclaration;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;

public class EditConfiguration
extends DefaultEditConfiguration {
    private Collection<String> messagesAlreadyDisplayed = new ArrayList<String>();

    public void configureRegistry(IConfigRegistry configRegistry) {
        super.configureRegistry(configRegistry);
        configRegistry.unregisterConfigAttribute(EditConfigAttributes.CELL_EDITOR, "NORMAL", null);
        INattableModelManager modelManager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
        BodyLayerStack bodyLayerStack = modelManager.getBodyLayerStack();
        Table table = modelManager.getTable();
        CellEditorDeclaration editorDeclaration = modelManager.getTable().getTableConfiguration().getCellEditorDeclaration();
        if (editorDeclaration.equals((Object)CellEditorDeclaration.COLUMN)) {
            if (table.isInvertAxis()) {
                CustomRowOverrideLabelAccumulator accumulator = new CustomRowOverrideLabelAccumulator((ILayer)bodyLayerStack);
                this.declaredCellEditors(modelManager.getRowElementsList(), configRegistry, null, accumulator);
                bodyLayerStack.setConfigLabelAccumulator((IConfigLabelAccumulator)accumulator);
            } else {
                ColumnOverrideLabelAccumulator accumulator = new ColumnOverrideLabelAccumulator((ILayer)bodyLayerStack);
                this.declaredCellEditors(modelManager.getColumnElementsList(), configRegistry, accumulator, null);
                bodyLayerStack.setConfigLabelAccumulator((IConfigLabelAccumulator)accumulator);
            }
        } else if (editorDeclaration.equals((Object)CellEditorDeclaration.ROW)) {
            if (table.isInvertAxis()) {
                ColumnOverrideLabelAccumulator accumulator = new ColumnOverrideLabelAccumulator((ILayer)bodyLayerStack);
                this.declaredCellEditors(modelManager.getColumnElementsList(), configRegistry, accumulator, null);
                bodyLayerStack.setConfigLabelAccumulator((IConfigLabelAccumulator)accumulator);
            } else {
                CustomRowOverrideLabelAccumulator accumulator = new CustomRowOverrideLabelAccumulator((ILayer)bodyLayerStack);
                this.declaredCellEditors(modelManager.getRowElementsList(), configRegistry, null, accumulator);
                bodyLayerStack.setConfigLabelAccumulator((IConfigLabelAccumulator)accumulator);
            }
        } else if (editorDeclaration.equals((Object)CellEditorDeclaration.CELL)) {
            throw new UnsupportedOperationException(Messages.EditConfiguration_DeclarationNotYetSupported);
        }
    }

    private void declaredCellEditors(List<Object> elements, IConfigRegistry configRegistry, ColumnOverrideLabelAccumulator columnAccumulator, CustomRowOverrideLabelAccumulator rowAccumulator) {
        boolean declareOnRow;
        INattableModelManager modelManager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
        boolean declareOnColumn = columnAccumulator != null;
        boolean bl = declareOnRow = rowAccumulator != null;
        assert (declareOnColumn != declareOnRow);
        CellEditorConfigurationFactory factory = CellEditorConfigurationFactory.INSTANCE;
        ArrayList<String> existingEditorIds = new ArrayList<String>();
        int i = 0;
        while (i < elements.size()) {
            Table table;
            IAxisCellEditorConfiguration config;
            Object current = elements.get(i);
            if (current instanceof IAxis) {
                current = ((IAxis)current).getElement();
            }
            if ((config = factory.getFirstCellEditorConfiguration(table = modelManager.getTable(), current)) != null) {
                ICellEditor editor = config.getICellEditor(table, current, modelManager.getTableAxisElementProvider());
                if (editor != null) {
                    String editorId = String.valueOf(config.getEditorConfigId()) + Integer.toString(i);
                    if (existingEditorIds.contains(editorId)) {
                        Activator.log.warn("Several editor have the same id");
                    } else {
                        existingEditorIds.add(editorId);
                    }
                    String cellId = String.valueOf(editorId) + "_cellId";
                    ICellPainter painter = config.getCellPainter(table, current);
                    String displayMode = config.getDisplayMode(table, current);
                    IDisplayConverter converter = config.getDisplayConvert(table, current, (ILabelProvider)new EMFLabelProvider());
                    IDataValidator validator = config.getDataValidator(table, current);
                    assert (!cellId.equals(editorId));
                    if (declareOnColumn) {
                        columnAccumulator.registerColumnOverrides(i, new String[]{editorId, cellId});
                    } else {
                        rowAccumulator.registerRowOverrides(i, editorId, cellId);
                    }
                    if (painter != null) {
                        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)painter, displayMode, cellId);
                    }
                    configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)editor, displayMode, editorId);
                    if (converter != null) {
                        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)converter, displayMode, cellId);
                    }
                    if (validator != null) {
                        configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)validator, displayMode, cellId);
                    }
                } else {
                    String errorMessage = NLS.bind((String)Messages.EditConfiguration_FactoryHandlesElementButDoesntProvideEditor, (Object)config.getEditorConfigId(), (Object)current);
                    if (!this.messagesAlreadyDisplayed.contains(errorMessage)) {
                        Activator.log.warn(errorMessage);
                        this.messagesAlreadyDisplayed.add(errorMessage);
                    }
                }
            } else {
                String errorMessage = NLS.bind((String)Messages.EditConfiguration_ConfigurationNotFound, (Object)current);
                if (!this.messagesAlreadyDisplayed.contains(errorMessage)) {
                    Activator.log.warn(errorMessage);
                    this.messagesAlreadyDisplayed.add(errorMessage);
                }
            }
            ++i;
        }
    }
}

